/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.WitherAuraLayer;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedWitherArmorLayer;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@OnlyIn(value=Dist.CLIENT)
public class PWitherRenderer
extends PatchedLivingEntityRenderer<WitherEntity, WitherPatch, WitherModel<WitherEntity>> {
    public static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = new ResourceLocation("textures/entity/wither/wither.png");

    public PWitherRenderer() {
        this.addPatchedLayer(WitherAuraLayer.class, new PatchedWitherArmorLayer());
    }

    @Override
    public void render(WitherEntity entityIn, WitherPatch entitypatch, LivingRenderer<WitherEntity, WitherModel<WitherEntity>> renderer, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean isVisible = this.isVisible(entityIn, entitypatch);
        boolean isVisibleToPlayer = !isVisible && !entityIn.func_98034_c((PlayerEntity)mc.field_71439_g);
        boolean isGlowing = mc.func_238206_b_((Entity)entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        ClientModel model = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        poseStack.func_227860_a_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (renderType != null) {
            int transparencyCount = entitypatch.getTransparency();
            if (transparencyCount == 0) {
                if (!entitypatch.isGhost()) {
                    IVertexBuilder builder = buffer.getBuffer(renderType);
                    model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poseMatrices);
                }
            } else {
                float transparency = ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
                if (transparencyCount < 0) {
                    transparency = 1.0f - transparency;
                }
                renderType = EpicFightRenderTypes.entityTranslucentTriangles(WITHER_LOCATION);
                IVertexBuilder builder1 = buffer.getBuffer(renderType);
                model.drawAnimatedModel(poseStack, builder1, packedLight, 1.0f, 1.0f, 1.0f, transparency, OverlayTexture.field_229196_a_, poseMatrices);
                renderType = EpicFightRenderTypes.entityTranslucentTriangles(WITHER_INVULNERABLE_LOCATION);
                IVertexBuilder builder2 = buffer.getBuffer(renderType);
                model.drawAnimatedModel(poseStack, builder2, packedLight, 1.0f, 1.0f, 1.0f, MathHelper.func_76126_a((float)(transparency * 3.1415f)), OverlayTexture.field_229196_a_, poseMatrices);
            }
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.func_227865_b_();
    }

    @Override
    protected boolean isVisible(WitherEntity witherboss, WitherPatch witherpatch) {
        return !witherpatch.isGhost() || witherpatch.getTransparency() != 0;
    }

    @Override
    public void mulPoseStack(MatrixStack poseStack, Armature armature, WitherEntity witherboss, WitherPatch entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, witherboss, entitypatch, partialTicks);
        float f = 1.0f;
        int i = witherboss.func_82212_n();
        if (i > 0) {
            f -= ((float)i - partialTicks) / 440.0f;
        }
        poseStack.func_227862_a_(f, f, f);
    }

    @Override
    protected void setJointTransforms(WitherPatch entitypatch, Armature armature, float partialTicks) {
        this.setJointTransform(1, armature, entitypatch.getHeadMatrix(partialTicks));
        WitherEntity witherBoss = (WitherEntity)entitypatch.getOriginal();
        float leftHeadYRot = witherBoss.field_82218_g[0] + (witherBoss.field_82221_e[0] - witherBoss.field_82218_g[0]) * partialTicks;
        float rightHeadYRot = witherBoss.field_82218_g[1] + (witherBoss.field_82221_e[1] - witherBoss.field_82218_g[1]) * partialTicks;
        float leftHeadXRot = witherBoss.field_82217_f[0] + (witherBoss.field_82220_d[0] - witherBoss.field_82217_f[0]) * partialTicks;
        float rightHeadXRot = witherBoss.field_82217_f[1] + (witherBoss.field_82220_d[1] - witherBoss.field_82217_f[1]) * partialTicks;
        this.setJointTransform(2, armature, OpenMatrix4f.createRotatorDeg(witherBoss.field_70761_aq - rightHeadYRot, Vec3f.Y_AXIS).rotateDeg(-rightHeadXRot, Vec3f.X_AXIS));
        this.setJointTransform(3, armature, OpenMatrix4f.createRotatorDeg(witherBoss.field_70761_aq - leftHeadYRot, Vec3f.Y_AXIS).rotateDeg(-leftHeadXRot, Vec3f.X_AXIS));
    }
}

