/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public abstract class PatchedLivingEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>>
extends PatchedEntityRenderer<E, T, LivingRenderer<E, M>> {
    private Map<Class<?>, PatchedLayer<E, T, M, ? extends LayerRenderer<E, M>>> patchedLayers = Maps.newHashMap();

    @Override
    public void render(E entityIn, T entitypatch, LivingRenderer<E, M> renderer, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLight, float partialTicks) {
        super.render(entityIn, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.func_71410_x();
        boolean isVisible = this.isVisible(entityIn, entitypatch);
        boolean isVisibleToPlayer = !isVisible && !entityIn.func_98034_c((PlayerEntity)mc.field_71439_g);
        boolean isGlowing = mc.func_238206_b_(entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        ClientModel model = ((LivingEntityPatch)entitypatch).getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        poseStack.func_227860_a_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks);
        if (renderType != null) {
            IVertexBuilder builder = buffer.getBuffer(renderType);
            model.drawAnimatedModel(poseStack, builder, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), poseMatrices);
        }
        if (!entityIn.func_175149_v()) {
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            for (Layer.Priority priority : Layer.Priority.values()) {
                AnimationPlayer animPlayer = ((LivingEntityPatch)entitypatch).getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, (LivingEntityPatch<?>)entitypatch, playTime, partialTicks);
            }
        }
        poseStack.func_227865_b_();
    }

    protected void renderLayer(LivingRenderer<E, M> renderer, T entitypatch, E entityIn, OpenMatrix4f[] poses, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLightIn, float partialTicks) {
        ArrayList layers = Lists.newArrayList();
        renderer.field_177097_h.forEach(layers::add);
        Iterator iter = layers.iterator();
        float f = MathUtils.lerpBetween(((LivingEntity)entityIn).field_70760_ar, ((LivingEntity)entityIn).field_70761_aq, partialTicks);
        float f1 = MathUtils.lerpBetween(((LivingEntity)entityIn).field_70758_at, ((LivingEntity)entityIn).field_70759_as, partialTicks);
        float f2 = f1 - f;
        float f7 = entityIn.func_195050_f(partialTicks);
        while (iter.hasNext()) {
            LayerRenderer layer2 = (LayerRenderer)iter.next();
            Class<?> rendererClass = layer2.getClass();
            if (rendererClass.isAnonymousClass()) {
                rendererClass = rendererClass.getSuperclass();
            }
            this.patchedLayers.computeIfPresent(rendererClass, (key, val) -> {
                val.renderLayer(0, entitypatch, entityIn, layer2, poseStack, buffer, packedLightIn, poses, f2, f7, partialTicks);
                iter.remove();
                return val;
            });
        }
        OpenMatrix4f modelMatrix = new OpenMatrix4f();
        modelMatrix.mulFront(((LivingEntityPatch)entitypatch).getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().searchJointById(this.getRootJointIndex()).getAnimatedTransform());
        OpenMatrix4f transpose = OpenMatrix4f.transpose(modelMatrix, null);
        poseStack.func_227860_a_();
        MathUtils.translateStack(poseStack, modelMatrix);
        MathUtils.rotateStack(poseStack, transpose);
        poseStack.func_227861_a_(0.0, this.getLayerCorrection(), 0.0);
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        layers.forEach(layer -> layer.func_225628_a_(poseStack, buffer, packedLightIn, (Entity)entityIn, entityIn.field_184619_aG, entityIn.field_70721_aZ, partialTicks, (float)entityIn.field_70173_aa, f2, f7));
        poseStack.func_227865_b_();
    }

    public RenderType getRenderType(E entityIn, T entitypatch, LivingRenderer<E, M> renderer, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        ResourceLocation resourcelocation = this.getEntityTexture(entitypatch, renderer);
        if (isVisibleToPlayer) {
            return EpicFightRenderTypes.itemEntityTranslucentCull(resourcelocation);
        }
        if (isVisible) {
            return EpicFightRenderTypes.animatedModel(resourcelocation);
        }
        return isGlowing ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    protected int getOverlayCoord(E entity, T entitypatch, float partialTicks) {
        return OverlayTexture.func_229201_a_((int)0, (int)OverlayTexture.func_229202_a_((((LivingEntity)entity).field_70737_aN > 5 ? 1 : 0) != 0));
    }

    @Override
    public void mulPoseStack(MatrixStack poseStack, Armature armature, E entityIn, T entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        if (entityIn.func_225608_bj_()) {
            poseStack.func_227861_a_(0.0, 0.15, 0.0);
        }
    }

    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends LayerRenderer<E, M>> patchedLayer) {
        this.patchedLayers.put(originalLayerClass, patchedLayer);
    }

    protected boolean isVisible(E entityIn, T entitypatch) {
        return !entityIn.func_82150_aj();
    }

    protected int getRootJointIndex() {
        return 0;
    }

    protected double getLayerCorrection() {
        return 1.15;
    }
}

