/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemBase {
    protected final OpenMatrix4f mainhandcorrectionMatrix;
    protected final OpenMatrix4f offhandCorrectionMatrix;
    protected static final OpenMatrix4f BACK_COORECTION = new OpenMatrix4f().translate(0.5f, 1.0f, 0.1f).rotateDeg(130.0f, Vec3f.Z_AXIS).rotateDeg(100.0f, Vec3f.Y_AXIS);
    public static RenderEngine renderEngine;

    public RenderItemBase() {
        this(new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS), new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS));
    }

    public RenderItemBase(OpenMatrix4f mainhandcorrectionMatrix, OpenMatrix4f offhandCorrectionMatrix) {
        this.mainhandcorrectionMatrix = mainhandcorrectionMatrix;
        this.offhandCorrectionMatrix = offhandCorrectionMatrix;
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, Hand hand, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLight) {
        OpenMatrix4f modelMatrix = this.getCorrectionMatrix(stack, entitypatch, hand);
        boolean isInMainhand = hand == Hand.MAIN_HAND;
        String holdingHand = isInMainhand ? "Tool_R" : "Tool_L";
        OpenMatrix4f jointTransform = entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().searchJointByName(holdingHand).getAnimatedTransform();
        modelMatrix.mulFront(jointTransform);
        poseStack.func_227860_a_();
        this.mulPoseStack(poseStack, modelMatrix);
        ItemCameraTransforms.TransformType transformType = isInMainhand ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)entitypatch.getOriginal(), stack, transformType, !isInMainhand, poseStack, buffer, packedLight);
        poseStack.func_227865_b_();
    }

    public void renderUnusableItemMount(ItemStack stack, LivingEntityPatch<?> entitypatch, IRenderTypeBuffer buffer, MatrixStack poseStack, int packedLight) {
        OpenMatrix4f modelMatrix = new OpenMatrix4f(BACK_COORECTION);
        modelMatrix.mulFront(entitypatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().searchJointById(0).getAnimatedTransform());
        poseStack.func_227860_a_();
        this.mulPoseStack(poseStack, modelMatrix);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.field_229196_a_, poseStack, buffer);
        poseStack.func_227865_b_();
    }

    protected void mulPoseStack(MatrixStack poseStack, OpenMatrix4f pose) {
        OpenMatrix4f transposed = pose.transpose(null);
        MathUtils.translateStack(poseStack, pose);
        MathUtils.rotateStack(poseStack, transposed);
        MathUtils.scaleStack(poseStack, transposed);
    }

    public OpenMatrix4f getCorrectionMatrix(ItemStack stack, LivingEntityPatch<?> itemHolder, Hand hand) {
        return new OpenMatrix4f(hand == Hand.MAIN_HAND ? this.mainhandcorrectionMatrix : this.offhandCorrectionMatrix);
    }
}

