/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayerPatch
extends AbstractClientPlayerPatch<ClientPlayerEntity> {
    private static final UUID ACTION_EVENT_UUID = UUID.fromString("d1a1e102-1621-11ed-861d-0242ac120002");
    private Minecraft minecraft;
    private LivingEntity rayTarget;
    private float prevStamina;

    @Override
    public void onConstructed(ClientPlayerEntity entity) {
        super.onConstructed(entity);
        this.minecraft = Minecraft.func_71410_x();
        ClientEngine.instance.inputController.setPlayerPatch(this);
    }

    @Override
    public void onJoinWorld(ClientPlayerEntity entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, ACTION_EVENT_UUID, playerEvent -> ClientEngine.instance.inputController.unlockHotkeys());
    }

    public void onRespawnLocalPlayer(ClientPlayerNetworkEvent.RespawnEvent event) {
        this.onJoinWorld(event.getNewPlayer(), new EntityJoinWorldEvent((Entity)event.getNewPlayer(), event.getNewPlayer().field_70170_p));
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.updateMotion(considerInaction);
        if (!this.getClientAnimator().isAiming() && this.currentCompositeMotion == LivingMotions.AIM) {
            ((ClientPlayerEntity)this.original).func_184605_cv();
            ClientEngine.instance.renderEngine.zoomIn();
        }
    }

    @Override
    public void clientTick(LivingEvent.LivingUpdateEvent event) {
        Entity hit;
        this.prevStamina = this.getStamina();
        super.clientTick(event);
        RayTraceResult rayResult = this.minecraft.field_71476_x;
        if (rayResult.func_216346_c() == RayTraceResult.Type.ENTITY && (hit = ((EntityRayTraceResult)rayResult).func_216348_a()) != this.rayTarget) {
            if (hit instanceof LivingEntity) {
                if (!(hit instanceof ArmorStandEntity)) {
                    this.rayTarget = (LivingEntity)hit;
                    this.rayTarget = (LivingEntity)hit;
                }
            } else if (hit instanceof PartEntity) {
                Entity parent = ((PartEntity)hit).getParent();
                if (parent instanceof LivingEntity) {
                    this.rayTarget = (LivingEntity)parent;
                }
            } else {
                this.rayTarget = null;
            }
            if (this.rayTarget != null) {
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(this.getTarget().func_145782_y()));
            }
        }
        if (this.rayTarget != null && (!this.rayTarget.func_70089_S() || ((ClientPlayerEntity)this.getOriginal()).func_70068_e((Entity)this.rayTarget) > 64.0 || this.getAngleTo((Entity)this.rayTarget) > 100.0)) {
            this.rayTarget = null;
            EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(-1));
        }
    }

    @Override
    protected void playReboundAnimation() {
        super.playReboundAnimation();
        ClientEngine.instance.renderEngine.zoomOut(40);
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
        EpicFightNetworkManager.sendToServer(new CPPlayAnimation(animation.getNamespaceId(), animation.getId(), convertTimeModifier, false, true));
    }

    @Override
    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        super.updateHeldItem(mainHandCap, offHandCap);
        if (EpicFightMod.CLIENT_INGAME_CONFIG.battleAutoSwitchItems.contains(((ClientPlayerEntity)this.original).func_184614_ca().func_77973_b())) {
            this.toBattleMode(true);
        } else if (EpicFightMod.CLIENT_INGAME_CONFIG.miningAutoSwitchItems.contains(((ClientPlayerEntity)this.original).func_184614_ca().func_77973_b())) {
            this.toMiningMode(true);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        AttackResult result = super.tryHurt(damageSource, amount);
        if (EpicFightMod.CLIENT_INGAME_CONFIG.autoPreparation.getValue().booleanValue() && result.resultType == AttackResult.ResultType.SUCCESS && !this.isBattleMode()) {
            this.toBattleMode(true);
        }
        return result;
    }

    @Override
    public LivingEntity getTarget() {
        return this.rayTarget;
    }

    @Override
    public boolean shouldSkipRender() {
        return !this.isBattleMode() && EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue() != false;
    }

    @Override
    public void toMiningMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.MINING) {
            ClientEngine.instance.renderEngine.downSlideSkillUI();
            if (EpicFightMod.CLIENT_INGAME_CONFIG.cameraAutoSwitch.getValue().booleanValue()) {
                this.minecraft.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.MINING));
            }
        }
        super.toMiningMode(synchronize);
    }

    @Override
    public void toBattleMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.BATTLE) {
            ClientEngine.instance.renderEngine.upSlideSkillUI();
            if (EpicFightMod.CLIENT_INGAME_CONFIG.cameraAutoSwitch.getValue().booleanValue()) {
                this.minecraft.field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.BATTLE));
            }
        }
        super.toBattleMode(synchronize);
    }

    @Override
    public boolean isFirstPerson() {
        return this.minecraft.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
    }

    @Override
    public boolean shouldBlockMoving() {
        return ClientEngine.instance.inputController.isKeyDown(this.minecraft.field_71474_y.field_74368_y);
    }

    public float getPrevStamina() {
        return this.prevStamina;
    }

    @Override
    public void openSkillBook(ItemStack itemstack, Hand hand) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("skill")) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SkillBookScreen((PlayerEntity)this.original, itemstack, hand));
        }
    }
}

