/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.provider.ProviderEntity;
import yesman.epicfight.world.capabilities.provider.ProviderItem;
import yesman.epicfight.world.capabilities.provider.ProviderProjectile;
import yesman.epicfight.world.capabilities.provider.ProviderSkill;

@Mod.EventBusSubscriber(modid="epicfight")
public class CapabilityEvent {
    @SubscribeEvent
    public static void attachItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ProviderItem prov;
        if (event.getObject() != null && (prov = new ProviderItem((ItemStack)event.getObject())).hasCapability()) {
            event.addCapability(new ResourceLocation("epicfight", "item_cap"), (ICapabilityProvider)prov);
        }
    }

    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Object prov;
        if (((Entity)event.getObject()).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null) == null && ((ProviderEntity)(prov = new ProviderEntity((Entity)event.getObject()))).hasCapability()) {
            PlayerPatch playerpatch;
            EntityPatch entityCap = (EntityPatch)prov.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            entityCap.onConstructed((Entity)event.getObject());
            event.addCapability(new ResourceLocation("epicfight", "entity_cap"), (ICapabilityProvider)prov);
            if (entityCap instanceof PlayerPatch && ((Entity)event.getObject()).getCapability(EpicFightCapabilities.CAPABILITY_SKILL).orElse(null) == null && (playerpatch = (PlayerPatch)entityCap) != null) {
                ProviderSkill skillProvider = new ProviderSkill(playerpatch);
                event.addCapability(new ResourceLocation("epicfight", "skill_cap"), (ICapabilityProvider)skillProvider);
            }
        }
        if (event.getObject() instanceof ProjectileEntity && ((Entity)event.getObject()).getCapability(EpicFightCapabilities.CAPABILITY_PROJECTILE).orElse(null) == null && ((ProviderProjectile)(prov = new ProviderProjectile((ProjectileEntity)event.getObject()))).hasCapability()) {
            event.addCapability(new ResourceLocation("epicfight", "projectile_cap"), (ICapabilityProvider)prov);
        }
    }
}

