/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.config.ConfigManager;
import yesman.epicfight.data.loot.EpicFightLootTables;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeGamerule;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.server.commands.PlayerModeCommand;
import yesman.epicfight.server.commands.PlayerSkillCommand;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

@Mod.EventBusSubscriber(modid="epicfight")
public class WorldEvents {
    @SubscribeEvent
    public static void onLootTableRegistry(LootTableLoadEvent event) {
        if (((Boolean)ConfigManager.SKILLBOOK_CHEST_LOOT.get()).booleanValue()) {
            EpicFightLootTables.modifyVanillaLootPools(event);
        }
    }

    @SubscribeEvent
    public static void onCommandRegistry(RegisterCommandsEvent event) {
        PlayerModeCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        PlayerSkillCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        PacketDistributor.PacketTarget target;
        ServerPlayerEntity player = event.getPlayer();
        PacketDistributor.PacketTarget packetTarget = target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        if (player != null) {
            EpicFightNetworkManager.sendToClient(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.WEIGHT_PENALTY, player.field_70170_p.func_82736_K().func_223592_c(EpicFightGamerules.WEIGHT_PENALTY)), target);
            EpicFightNetworkManager.sendToClient(new SPChangeGamerule(SPChangeGamerule.SynchronizedGameRules.DIABLE_ENTITY_UI, player.field_70170_p.func_82736_K().func_223586_b(EpicFightGamerules.DISABLE_ENTITY_UI)), target);
        }
        if (player == null || !player.func_184102_h().func_213199_b(player.func_146103_bH())) {
            SPDatapackSync armorPacket = new SPDatapackSync(ItemCapabilityReloadListener.armorCount(), SPDatapackSync.Type.ARMOR);
            SPDatapackSync weaponPacket = new SPDatapackSync(ItemCapabilityReloadListener.weaponCount(), SPDatapackSync.Type.WEAPON);
            SPDatapackSync mobPatchPacket = new SPDatapackSync(MobPatchReloadListener.getTagSize(), SPDatapackSync.Type.MOB);
            ItemCapabilityReloadListener.getArmorDataStream().forEach(armorPacket::write);
            ItemCapabilityReloadListener.getWeaponDataStream().forEach(weaponPacket::write);
            MobPatchReloadListener.getDataStream().forEach(mobPatchPacket::write);
            EpicFightNetworkManager.sendToClient(armorPacket, target);
            EpicFightNetworkManager.sendToClient(weaponPacket, target);
            EpicFightNetworkManager.sendToClient(mobPatchPacket, target);
        }
    }
}

