/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@Mixin(value={WitherEntity.class})
public abstract class MixinWitherBoss
extends MonsterEntity
implements IChargeableMob,
IRangedAttackMob {
    @Shadow
    @Final
    private final int[] field_82223_h = new int[2];
    @Shadow
    @Final
    private final int[] field_82224_i = new int[2];
    @Shadow
    @Final
    private ServerBossInfo field_184744_bE;
    @Shadow
    private int field_82222_j;
    @Unique
    private WitherPatch epicfightPatch;

    protected MixinWitherBoss(EntityType<? extends WitherEntity> entityType, World level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void epixfight_witherBossInit(CallbackInfo info) {
        this.epicfightPatch = (WitherPatch)((WitherEntity)this).getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep()V"}, cancellable=true)
    private void epicfight_aiStep(CallbackInfo info) {
        if (this.epicfightPatch != null) {
            info.cancel();
            WitherEntity self = (WitherEntity)this.epicfightPatch.getOriginal();
            super.func_70636_d();
            for (int i = 0; i < 2; ++i) {
                self.field_82218_g[i] = self.field_82221_e[i];
                self.field_82217_f[i] = self.field_82220_d[i];
            }
            for (int j = 0; j < 2; ++j) {
                int k = self.func_82203_t(j + 1);
                Entity entity1 = null;
                if (k > 0) {
                    entity1 = this.field_70170_p.func_73045_a(k);
                }
                if (this.epicfightPatch.getLaserTargetEntity(j + 1) != null) {
                    Entity laserTarget = this.epicfightPatch.getLaserTargetEntity(j + 1);
                    this.lookAt(j, laserTarget.func_226277_ct_(), laserTarget.func_226280_cw_(), laserTarget.func_226281_cx_(), 360.0f, 360.0f);
                    continue;
                }
                if (MixinWitherBoss.isValid(this.epicfightPatch.getLaserTargetPosition(j + 1))) {
                    Vector3d laserTargetPosition = this.epicfightPatch.getLaserTargetPosition(j + 1);
                    this.lookAt(j, laserTargetPosition.field_72450_a, laserTargetPosition.field_72448_b, laserTargetPosition.field_72449_c, 360.0f, 360.0f);
                    continue;
                }
                if (this.epicfightPatch.getEntityState().inaction()) {
                    self.field_82220_d[j] = this.func_82204_b(self.field_82220_d[j], 0.0f, 40.0f);
                    self.field_82221_e[j] = this.func_82204_b(self.field_82221_e[j], this.field_70761_aq, 10.0f);
                    continue;
                }
                if (entity1 != null) {
                    this.lookAt(j, entity1.func_226277_ct_(), entity1.func_226280_cw_(), entity1.func_226281_cx_(), 40.0f, 10.0f);
                    continue;
                }
                self.field_82221_e[j] = this.func_82204_b(self.field_82221_e[j], this.field_70761_aq, 10.0f);
            }
            boolean powered = this.func_225509_J__();
            for (int l = 0; l < 3; ++l) {
                double subHeadX = self.func_82214_u(l);
                double subHeadY = self.func_82208_v(l);
                double subHeadZ = self.func_82213_w(l);
                if (this.epicfightPatch.isGhost()) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, subHeadX + this.field_70146_Z.nextGaussian() * (double)0.3f, subHeadY + this.field_70146_Z.nextGaussian() * (double)0.3f, subHeadZ + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
                if (!powered || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, subHeadX + this.field_70146_Z.nextGaussian() * (double)0.3f, subHeadY + this.field_70146_Z.nextGaussian() * (double)0.3f, subHeadZ + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
            }
            if (self.func_82212_n() > 0) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextGaussian(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.func_226281_cx_() + this.field_70146_Z.nextGaussian(), (double)0.7f, (double)0.7f, (double)0.9f);
                }
            }
        }
    }

    @Unique
    private void lookAt(int head, double x, double y, double z, float lerpX, float lerpY) {
        WitherEntity self = (WitherEntity)this.epicfightPatch.getOriginal();
        double d9 = self.func_82214_u(head + 1);
        double d1 = self.func_82208_v(head + 1);
        double d3 = self.func_82213_w(head + 1);
        double d4 = x - d9;
        double d5 = y - d1;
        double d6 = z - d3;
        double d7 = Math.sqrt(d4 * d4 + d6 * d6);
        float f = (float)(MathHelper.func_181159_b((double)d6, (double)d4) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d5, (double)d7) * 57.29577951308232));
        self.field_82220_d[head] = this.func_82204_b(self.field_82220_d[head], f1, lerpX);
        self.field_82221_e[head] = this.func_82204_b(self.field_82221_e[head], f, lerpY);
    }

    @Inject(at={@At(value="HEAD")}, method={"customServerAiStep()V"}, cancellable=true)
    private void epicfight_customServerAiStep(CallbackInfo info) {
        if (this.epicfightPatch != null) {
            info.cancel();
            WitherEntity self = (WitherEntity)this.epicfightPatch.getOriginal();
            if (self.func_82212_n() > 0) {
                int k1 = self.func_82212_n() - 1;
                this.field_184744_bE.func_186735_a(1.0f - (float)k1 / 220.0f);
                if (k1 <= 0) {
                    Explosion.Mode explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((World)self.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                    self.field_70170_p.func_217398_a((Entity)this, self.func_226277_ct_(), self.func_226280_cw_(), self.func_226281_cx_(), 7.0f, false, explosion$blockinteraction);
                    if (!self.func_174814_R()) {
                        self.field_70170_p.func_175669_a(1023, self.func_233580_cy_(), 0);
                    }
                }
                self.func_82215_s(k1);
                if (self.field_70173_aa % 10 == 0) {
                    self.func_70691_i(10.0f);
                }
            } else {
                super.func_70619_bc();
                for (int i = 1; i < 3; ++i) {
                    if (self.field_70173_aa < this.field_82223_h[i - 1]) continue;
                    this.field_82223_h[i - 1] = self.field_70173_aa + 10 + self.func_70681_au().nextInt(10);
                    if (!(self.field_70170_p.func_175659_aa() != Difficulty.NORMAL && self.field_70170_p.func_175659_aa() != Difficulty.HARD || this.epicfightPatch.getEntityState().inaction())) {
                        int i3 = i - 1;
                        int j3 = this.field_82224_i[i - 1];
                        this.field_82224_i[i3] = this.field_82224_i[i - 1] + 1;
                        if (j3 > 15) {
                            double d0 = MathHelper.func_82716_a((Random)self.func_70681_au(), (double)(self.func_226277_ct_() - 10.0), (double)(self.func_226277_ct_() + 10.0));
                            double d1 = MathHelper.func_82716_a((Random)self.func_70681_au(), (double)(self.func_226278_cu_() - 5.0), (double)(self.func_226278_cu_() + 5.0));
                            double d2 = MathHelper.func_82716_a((Random)self.func_70681_au(), (double)(self.func_226281_cx_() - 10.0), (double)(self.func_226281_cx_() + 10.0));
                            self.func_82209_a(i + 1, d0, d1, d2, true);
                            this.field_82224_i[i - 1] = 0;
                        }
                    }
                    int l1 = self.func_82203_t(i);
                    if (this.epicfightPatch.getEntityState().inaction()) {
                        this.field_82223_h[i - 1] = self.field_70173_aa + 30;
                    }
                    if (l1 > 0) {
                        LivingEntity livingentity = (LivingEntity)self.field_70170_p.func_73045_a(l1);
                        if (livingentity != null && self.func_213336_c(livingentity) && !(self.func_70068_e((Entity)livingentity) > 900.0) && self.func_70685_l((Entity)livingentity)) {
                            if (this.epicfightPatch.getEntityState().inaction()) continue;
                            self.func_82216_a(i + 1, livingentity);
                            this.field_82223_h[i - 1] = self.field_70173_aa + 40 + self.func_70681_au().nextInt(20);
                            this.field_82224_i[i - 1] = 0;
                            continue;
                        }
                        self.func_82211_c(i, 0);
                        continue;
                    }
                    List list = self.field_70170_p.func_217374_a(LivingEntity.class, WitherPatch.WTIHER_TARGETING_CONDITIONS, (LivingEntity)this, self.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0));
                    if (list.isEmpty()) continue;
                    LivingEntity livingentity1 = (LivingEntity)list.get(self.func_70681_au().nextInt(list.size()));
                    self.func_82211_c(i, livingentity1.func_145782_y());
                }
                if (self.func_70638_az() != null) {
                    self.func_82211_c(0, self.func_70638_az().func_145782_y());
                } else {
                    self.func_82211_c(0, 0);
                }
                if (this.field_82222_j > 0) {
                    --this.field_82222_j;
                    if (this.field_82222_j == 0 && ForgeEventFactory.getMobGriefingEvent((World)self.field_70170_p, (Entity)this)) {
                        int j1 = MathHelper.func_76128_c((double)self.func_226278_cu_());
                        int i2 = MathHelper.func_76128_c((double)self.func_226277_ct_());
                        int j2 = MathHelper.func_76128_c((double)self.func_226281_cx_());
                        boolean flag = false;
                        for (int j = -1; j <= 1; ++j) {
                            for (int k2 = -1; k2 <= 1; ++k2) {
                                for (int k = 0; k <= 3; ++k) {
                                    int l2 = i2 + j;
                                    int l = j1 + k;
                                    int i1 = j2 + k2;
                                    BlockPos blockpos = new BlockPos(l2, l, i1);
                                    BlockState blockstate = self.field_70170_p.func_180495_p(blockpos);
                                    if (!blockstate.canEntityDestroy((IBlockReader)self.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                                    flag = self.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
                                }
                            }
                        }
                        if (flag) {
                            self.field_70170_p.func_217378_a((PlayerEntity)null, 1022, self.func_233580_cy_(), 0);
                        }
                    }
                }
                this.field_184744_bE.func_186735_a(self.func_110143_aJ() / self.func_110138_aP());
            }
        }
    }

    @Unique
    public boolean func_175149_v() {
        return this.epicfightPatch != null ? this.epicfightPatch.isGhost() : super.func_175149_v();
    }

    @Unique
    protected SoundEvent func_184639_G() {
        return this.epicfightPatch != null ? (this.epicfightPatch.isGhost() ? null : SoundEvents.field_187925_gy) : null;
    }

    @Shadow
    public abstract float func_82204_b(float var1, float var2, float var3);

    private static boolean isValid(Vector3d vec) {
        return !Double.isNaN(vec.field_72450_a) && !Double.isNaN(vec.field_72448_b) && !Double.isNaN(vec.field_72449_c);
    }
}

