/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class SPAddSkill {
    private String[] skillNames;
    private int count;

    public SPAddSkill() {
        this("");
    }

    public SPAddSkill(String ... skillNames) {
        this.skillNames = skillNames;
        this.count = skillNames.length;
    }

    public static SPAddSkill fromBytes(PacketBuffer buf) {
        SPAddSkill msg = new SPAddSkill();
        int count = buf.readInt();
        msg.skillNames = new String[count];
        for (int i = 0; i < count; ++i) {
            msg.skillNames[i] = buf.func_218666_n();
        }
        return msg;
    }

    public static void toBytes(SPAddSkill msg, PacketBuffer buf) {
        buf.writeInt(msg.count);
        for (String skillName : msg.skillNames) {
            buf.func_180714_a(skillName);
        }
    }

    public static void handle(SPAddSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            LocalPlayerPatch playerpatch = (LocalPlayerPatch)mc.field_71439_g.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            CapabilitySkill skillCapability = playerpatch.getSkillCapability();
            for (String skillName : msg.skillNames) {
                skillCapability.addLearnedSkill(Skills.getSkill(skillName));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

