/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SPChangePlayerMode {
    private int entityId;
    private PlayerPatch.PlayerMode mode;

    public SPChangePlayerMode() {
        this.entityId = 0;
        this.mode = PlayerPatch.PlayerMode.MINING;
    }

    public SPChangePlayerMode(int entityId, PlayerPatch.PlayerMode battleMode) {
        this.entityId = entityId;
        this.mode = battleMode;
    }

    public static SPChangePlayerMode fromBytes(PacketBuffer buf) {
        return new SPChangePlayerMode(buf.readInt(), PlayerPatch.PlayerMode.values()[buf.readInt()]);
    }

    public static void toBytes(SPChangePlayerMode msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.mode.ordinal());
    }

    public static void handle(SPChangePlayerMode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerPatch playerpatch;
            Minecraft mc = Minecraft.func_71410_x();
            Entity entity = mc.field_71439_g.field_70170_p.func_73045_a(msg.entityId);
            if (entity != null && (playerpatch = (PlayerPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null)) != null) {
                playerpatch.toMode(msg.mode, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

