/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SPPlayAnimation {
    protected int namespaceId;
    protected int animationId;
    protected int entityId;
    protected float convertTimeModifier;

    public SPPlayAnimation() {
        this.animationId = 0;
        this.entityId = 0;
        this.convertTimeModifier = 0.0f;
    }

    public SPPlayAnimation(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch<?> entitypatch) {
        this(animation.getNamespaceId(), animation.getId(), ((LivingEntity)entitypatch.getOriginal()).func_145782_y(), convertTimeModifier);
    }

    public SPPlayAnimation(StaticAnimation animation, int entityId, float convertTimeModifier) {
        this(animation.getNamespaceId(), animation.getId(), entityId, convertTimeModifier);
    }

    public SPPlayAnimation(int namespaceId, int animation, int entityId, float convertTimeModifier) {
        this.namespaceId = namespaceId;
        this.animationId = animation;
        this.entityId = entityId;
        this.convertTimeModifier = convertTimeModifier;
    }

    public <T extends SPPlayAnimation> void onArrive() {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.field_71439_g.field_70170_p.func_73045_a(this.entityId);
        if (entity == null) {
            return;
        }
        LivingEntityPatch entitypatch = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch != null) {
            ((Animator)entitypatch.getAnimator()).playAnimation(this.namespaceId, this.animationId, this.convertTimeModifier);
        }
    }

    public static SPPlayAnimation fromBytes(PacketBuffer buf) {
        return new SPPlayAnimation(buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat());
    }

    public static void toBytes(SPPlayAnimation msg, ByteBuf buf) {
        buf.writeInt(msg.namespaceId);
        buf.writeInt(msg.animationId);
        buf.writeInt(msg.entityId);
        buf.writeFloat(msg.convertTimeModifier);
    }

    public static void handle(SPPlayAnimation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> msg.onArrive());
        ctx.get().setPacketHandled(true);
    }
}

