/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.GuardSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ActiveGuardSkill
extends GuardSkill {
    private static final SkillDataManager.SkillDataKey<Integer> LAST_ACTIVE = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> PARRY_MOTION_COUNTER = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);

    public static GuardSkill.Builder createBuilder(ResourceLocation resourceLocation) {
        return GuardSkill.createBuilder(resourceLocation).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> {
            StaticAnimation[] staticAnimationArray;
            if (itemCap.getStyle((LivingEntityPatch<?>)playerpatch) == CapabilityItem.Styles.ONE_HAND) {
                StaticAnimation[] staticAnimationArray2 = new StaticAnimation[2];
                staticAnimationArray2[0] = Animations.SWORD_GUARD_ACTIVE_HIT1;
                staticAnimationArray = staticAnimationArray2;
                staticAnimationArray2[1] = Animations.SWORD_GUARD_ACTIVE_HIT2;
            } else {
                StaticAnimation[] staticAnimationArray3 = new StaticAnimation[2];
                staticAnimationArray3[0] = Animations.SWORD_GUARD_ACTIVE_HIT2;
                staticAnimationArray = staticAnimationArray3;
                staticAnimationArray3[1] = Animations.SWORD_GUARD_ACTIVE_HIT3;
            }
            return staticAnimationArray;
        }).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2}).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.KATANA, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2}).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2});
    }

    public ActiveGuardSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(LAST_ACTIVE);
        container.getDataManager().registerData(PARRY_MOTION_COUNTER);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(Hand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && this.isExecutableState((PlayerPatch<?>)event.getPlayerPatch())) {
                ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).func_184598_c(Hand.MAIN_HAND);
            }
            container.getDataManager().setData(LAST_ACTIVE, ((ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).field_70173_aa);
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = (DamageSource)event.getDamageSource(), true)) {
            ServerPlayerEntity playerentity = (ServerPlayerEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            boolean successParrying = playerentity.field_70173_aa - container.getDataManager().getDataValue(LAST_ACTIVE) < 8;
            float penalty = ((Float)container.getDataManager().getDataValue(PENALTY)).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerWorld)playerentity.field_70170_p, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.func_76364_f());
            if (successParrying) {
                penalty = 0.1f;
                knockback *= 0.4f;
            } else {
                container.getDataManager().setDataSync(PENALTY, Float.valueOf(penalty += this.getPenaltyMultiplier(itemCapability)), playerentity);
            }
            if (damageSource.func_76364_f() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)damageSource.func_76364_f())) * 0.1f;
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.func_76364_f().func_213303_ch(), knockback);
            float stamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() - penalty * impact;
            ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(stamina);
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (stamina >= 0.0f ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            StaticAnimation animation = this.getGuardMotion((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.NEUTRALIZE_MOBS, 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event);
            return;
        }
        super.guard(container, itemCapability, event, knockback, impact, false);
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.func_76352_a() && advanced || super.isBlockableSource(damageSource, false);
    }

    @Override
    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        StaticAnimation[] motions;
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD && (motions = (StaticAnimation[])this.getGuradMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch)) != null) {
            SkillDataManager dataManager = playerpatch.getSkill(this.getCategory()).getDataManager();
            int motionCounter = dataManager.getDataValue(PARRY_MOTION_COUNTER);
            dataManager.setDataF(PARRY_MOTION_COUNTER, v -> v + 1);
            return motions[motionCounter %= motions.length];
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    @Override
    public Skill getPriorSkill() {
        return Skills.GUARD;
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs() {
        ArrayList list = Lists.newArrayList();
        list.add(String.format("%s, %s, %s, %s", CapabilityItem.WeaponCategories.KATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI).toLowerCase());
        return list;
    }
}

