/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BasicAttack
extends Skill {
    private static final SkillDataManager.SkillDataKey<Integer> COMBO_COUNTER = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("a42e0198-fdbc-11eb-9a03-0242ac130003");

    public static Skill.Builder<BasicAttack> createBuilder() {
        return new Skill.Builder(new ResourceLocation("epicfight", "basic_attack")).setCategory(SkillCategories.BASIC_ATTACK).setConsumption(0.0f).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public BasicAttack(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(COMBO_COUNTER);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!event.getAnimation().isBasicAttackAnimation()) {
                container.getDataManager().setData(COMBO_COUNTER, 0);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        PlayerEntity player = (PlayerEntity)executer.getOriginal();
        return !player.func_175149_v() && !executer.isUnstable() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        if (executer.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, new BasicAttackEvent(executer))) {
            return;
        }
        CapabilityItem cap = executer.getHoldingItemCapability(Hand.MAIN_HAND);
        StaticAnimation attackMotion = null;
        ServerPlayerEntity player = (ServerPlayerEntity)executer.getOriginal();
        SkillDataManager dataManager = executer.getSkill(this.category).getDataManager();
        int comboCounter = dataManager.getDataValue(COMBO_COUNTER);
        if (player.func_184218_aH()) {
            Entity entity = player.func_184187_bx();
            if (entity instanceof IJumpingMount && ((IJumpingMount)entity).func_184776_b() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                attackMotion = cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size());
                ++comboCounter;
            }
        } else {
            List<StaticAnimation> combo = cap.getAutoAttckMotion(executer);
            int comboSize = combo.size();
            boolean dashAttack = player.func_70051_ag();
            comboCounter = dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2);
            attackMotion = combo.get(comboCounter);
            comboCounter = dashAttack ? 0 : comboCounter + 1;
        }
        dataManager.setData(COMBO_COUNTER, comboCounter);
        if (attackMotion != null) {
            executer.playAnimationSynchronized(attackMotion, 0.0f);
        }
        executer.updateEntityState();
    }

    @Override
    public void updateContainer(SkillContainer container) {
        if (container.getExecuter().getTickSinceLastAction() > 10 && container.getDataManager().getDataValue(COMBO_COUNTER) > 0) {
            container.getDataManager().setData(COMBO_COUNTER, 0);
        }
    }
}

