/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BerserkerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("fdc09ee8-fcfc-11eb-9a03-0242ac130003");

    public BerserkerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID, event -> {
            PlayerEntity player = (PlayerEntity)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.func_110143_aJ();
            float maxHealth = player.func_110138_aP();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.005f;
            float attackSpeed = event.getAttackSpeed();
            event.setAttackSpeed(Math.min(5.0f, attackSpeed * (1.0f + lostHealthPercentage)));
        });
        listener.addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID, event -> {
            PlayerEntity player = (PlayerEntity)((EntityPatch)event.getPlayerPatch()).getOriginal();
            float health = player.func_110143_aJ();
            float maxHealth = player.func_110138_aP();
            float lostHealthPercentage = (maxHealth - health) / maxHealth;
            lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.003f;
            float attackDamage = event.getAttackDamage();
            event.setAttackDamage(attackDamage * (1.0f + lostHealthPercentage));
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        PlayerEntity player = (PlayerEntity)container.getExecuter().getOriginal();
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        return maxHealth - health > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, MatrixStack matStackIn, float x, float y, float scale, int width, int height) {
        matStackIn.func_227860_a_();
        matStackIn.func_227862_a_(scale, scale, 1.0f);
        matStackIn.func_227861_a_(0.0, (double)((float)gui.getSlidingProgression() * 1.0f / scale), 0.0);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(this.getSkillTexture());
        float scaleMultiply = 1.0f / scale;
        gui.drawTexturedModalRectFixCoord(matStackIn.func_227866_c_().func_227870_a_(), ((float)width - x) * scaleMultiply, ((float)height - y) * scaleMultiply, 0, 0, 255, 255);
        matStackIn.func_227862_a_(scaleMultiply, scaleMultiply, 1.0f);
        PlayerEntity player = (PlayerEntity)container.getExecuter().getOriginal();
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f);
        gui.font.func_238405_a_(matStackIn, String.format("%.0f%%", Float.valueOf(lostHealthPercentage)), (float)width - x + 4.0f, (float)height - y + 6.0f, 0xFFFFFF);
        matStackIn.func_227865_b_();
    }
}

