/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SpecialAttackSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BladeRushSkill
extends SpecialAttackSkill {
    private static final SkillDataManager.SkillDataKey<Integer> COMBO_COUNT = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("444a1a6a-c2f1-11eb-8529-0242ac130003");

    public BladeRushSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public PacketBuffer gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.writeBoolean(true);
        return buf;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(COMBO_COUNT);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            int animationId = event.getDamageSource().getAnimationId();
            if (animationId >= Animations.BLADE_RUSH_FIRST.getId() && animationId <= Animations.BLADE_RUSH_FINISHER.getId() && !event.getTarget().func_70089_S()) {
                this.setStackSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.stack + 1);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (container.isActivated() && !container.isDisabled()) {
                PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                buf.writeBoolean(false);
                this.executeOnServer((ServerPlayerPatch)event.getPlayerPatch(), buf);
                event.setCanceled(true);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        if (executer.getSkill(this.category).isActivated() && args.readBoolean()) {
            this.cancelOnServer(executer, null);
        } else {
            int firstComboId = Animations.BLADE_RUSH_FIRST.getId();
            int animationId = firstComboId + executer.getSkill(this.category).getDataManager().getDataValue(COMBO_COUNT);
            executer.playAnimationSynchronized(EpicFightMod.getInstance().animationManager.findAnimationById("epicfight".hashCode(), animationId), 0.0f);
            executer.getSkill(this.category).getDataManager().setDataF(COMBO_COUNT, v -> (v + 1) % 4);
            this.setDurationSynchronize(executer, this.maxDuration);
            this.setStackSynchronize(executer, executer.getSkill(this.category).getStack() - 1);
            executer.getSkill(this.category).activate();
        }
    }

    @Override
    public void cancelOnClient(LocalPlayerPatch executer, PacketBuffer args) {
        executer.getSkill(this.category).deactivate();
    }

    @Override
    public void cancelOnServer(ServerPlayerPatch executer, PacketBuffer args) {
        executer.getSkill(this.category).deactivate();
        executer.getSkill(this.category).getDataManager().setData(COMBO_COUNT, 0);
        EpicFightNetworkManager.sendToPlayer(new SPSkillExecutionFeedback(this.category.universalOrdinal(), false), (ServerPlayerEntity)executer.getOriginal());
    }

    @Override
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<ITextComponent> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Last Strike:");
        return list;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        ((AttackAnimation)Animations.BLADE_RUSH_FIRST).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_SECOND).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_THIRD).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_FINISHER).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
        if (playerpatch.getSkill(this.category).isActivated()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("epicfight", "textures/gui/overlay/blade_rush.png"));
            GlStateManager.func_227740_m_();
            GlStateManager.func_227731_j_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_225582_a_(0.0, 0.0, 1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, (double)resolutionY, 1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)resolutionX, (double)resolutionY, 1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)resolutionX, 0.0, 1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

