/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.ValueCorrector;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class SpecialAttackSkill
extends Skill {
    protected List<Map<AnimationProperty.AttackPhaseProperty<?>, Object>> properties = Lists.newArrayList();

    public static Skill.Builder<? extends SpecialAttackSkill> createBuilder(ResourceLocation resourceLocation) {
        return new Skill.Builder(resourceLocation).setCategory(SkillCategories.WEAPON_SPECIAL_ATTACK).setResource(Skill.Resource.SPECIAL_GAUAGE);
    }

    public SpecialAttackSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return executer.getSkill(this.getCategory()).isReady() || ((PlayerEntity)executer.getOriginal()).func_184812_l_();
        }
        return executer.getHoldingItemCapability(Hand.MAIN_HAND).getSpecialAttack(executer) == this && ((PlayerEntity)executer.getOriginal()).func_184187_bx() == null && (!executer.getSkill(this.category).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslatableText();
        list.add(new TranslationTextComponent(traslatableText).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent(String.format("[%.0f]", Float.valueOf(this.consumption))).func_240699_a_(TextFormatting.AQUA)));
        list.add(new TranslationTextComponent(traslatableText + ".tooltip").func_240699_a_(TextFormatting.DARK_GRAY));
        return list;
    }

    protected void generateTooltipforPhase(List<ITextComponent> list, ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch, Map<AnimationProperty.AttackPhaseProperty<?>, Object> propertyMap, String title) {
        Multimap attributes = itemStack.func_111283_C(EquipmentSlotType.MAINHAND);
        Multimap<Attribute, AttributeModifier> capAttributes = cap.getAttributeModifiers(EquipmentSlotType.MAINHAND, playerpatch);
        double damage = ((PlayerEntity)playerpatch.getOriginal()).func_110148_a(Attributes.field_233823_f_).func_111125_b() + (double)EnchantmentHelper.func_152377_a((ItemStack)itemStack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        double armorNegation = ((PlayerEntity)playerpatch.getOriginal()).func_110148_a((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111125_b();
        double impact = ((PlayerEntity)playerpatch.getOriginal()).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111125_b();
        double maxStrikes = ((PlayerEntity)playerpatch.getOriginal()).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111125_b();
        ValueCorrector damageCorrector = ValueCorrector.empty();
        ValueCorrector armorNegationCorrector = ValueCorrector.empty();
        ValueCorrector impactCorrector = ValueCorrector.empty();
        ValueCorrector maxStrikesCorrector = ValueCorrector.empty();
        for (AttributeModifier modifier : attributes.get((Object)Attributes.field_233823_f_)) {
            damage += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)EpicFightAttributes.ARMOR_NEGATION.get())) {
            armorNegation += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)EpicFightAttributes.IMPACT.get())) {
            impact += modifier.func_111164_d();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)EpicFightAttributes.MAX_STRIKES.get())) {
            maxStrikes += modifier.func_111164_d();
        }
        this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, propertyMap).ifPresent(damageCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION, propertyMap).ifPresent(armorNegationCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT, propertyMap).ifPresent(impactCorrector::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES, propertyMap).ifPresent(maxStrikesCorrector::merge);
        impactCorrector.merge(ValueCorrector.multiplier(1.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) * 0.12f));
        damage = damageCorrector.getTotalValue(playerpatch.getDamageToEntity(null, null, (float)damage));
        armorNegation = armorNegationCorrector.getTotalValue((float)armorNegation);
        impact = impactCorrector.getTotalValue((float)impact);
        maxStrikes = maxStrikesCorrector.getTotalValue((float)maxStrikes);
        list.add((ITextComponent)new StringTextComponent(title).func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.GRAY));
        IFormattableTextComponent damageComponent = new TranslationTextComponent("skill.epicfight.damage", new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(damage)).func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_GRAY);
        this.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, propertyMap).ifPresent(extraDamage -> damageComponent.func_230529_a_((ITextComponent)new TranslationTextComponent(extraDamage.toString(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(extraDamage.getArgument() * 100.0f) + "%").func_240699_a_(TextFormatting.RED)})).func_240699_a_(TextFormatting.DARK_GRAY));
        list.add((ITextComponent)damageComponent);
        if (armorNegation != 0.0) {
            list.add((ITextComponent)new TranslationTextComponent(((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(armorNegation)).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        if (impact != 0.0) {
            list.add((ITextComponent)new TranslationTextComponent(((Attribute)EpicFightAttributes.IMPACT.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(impact)).func_240699_a_(TextFormatting.AQUA)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        list.add((ITextComponent)new TranslationTextComponent(((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_233754_c_(), new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(maxStrikes)).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.DARK_GRAY));
        Optional<ExtendedDamageSource.StunType> stunOption = this.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, propertyMap);
        stunOption.ifPresent(stunType -> list.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "Apply " + stunType.toString())));
        if (!stunOption.isPresent()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "Apply " + ExtendedDamageSource.StunType.SHORT.toString()));
        }
    }

    protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, Map<AnimationProperty.AttackPhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyType));
    }

    public SpecialAttackSkill newPropertyLine() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> SpecialAttackSkill addProperty(AnimationProperty.AttackPhaseProperty<T> attribute, T object) {
        this.properties.get(this.properties.size() - 1).put(attribute, object);
        return this;
    }

    public abstract SpecialAttackSkill registerPropertiesToAnimation();
}

