/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SwordmasterSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a395b692-fd97-11eb-9a03-0242ac130003");
    private static final CapabilityItem.WeaponCategories[] AVAILABLE_WEAPON_TYPES = new CapabilityItem.WeaponCategories[]{CapabilityItem.WeaponCategories.KATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI};

    public SwordmasterSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID, event -> {
            WeaponCategory heldWeaponCategory = event.getItemCapability().getWeaponCategory();
            for (CapabilityItem.WeaponCategories weaponCategory : AVAILABLE_WEAPON_TYPES) {
                if (weaponCategory != heldWeaponCategory) continue;
                float attackSpeed = event.getAttackSpeed();
                event.setAttackSpeed(attackSpeed * 1.3f);
                break;
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_SPEED_MODIFY_EVENT, EVENT_UUID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgs() {
        ArrayList list = Lists.newArrayList();
        list.add(String.format("%s, %s, %s, %s", AVAILABLE_WEAPON_TYPES).toLowerCase());
        return list;
    }
}

