/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import java.util.UUID;
import net.minecraft.util.DamageSource;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Formulars;
import yesman.epicfight.skill.PassiveSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class TechnicianSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("99e5c782-fdaf-11eb-9a03-0242ac130003");
    private static final SkillDataManager.SkillDataKey<Boolean> CURRENTLY_ACTIVATED = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.BOOLEAN);

    public TechnicianSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(CURRENTLY_ACTIVATED);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation() instanceof DodgeAnimation) {
                container.getDataManager().setData(CURRENTLY_ACTIVATED, false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
            if (((Animator)executer.getAnimator()).getPlayerFor(null).getAnimation() instanceof DodgeAnimation) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                if (executer.getEntityState().invulnerableTo(damageSource) && !container.getDataManager().getDataValue(CURRENTLY_ACTIVATED).booleanValue()) {
                    float consumption = Formulars.getStaminarConsumePenalty(executer.getWeight(), executer.getSkill((SkillCategory)SkillCategories.DODGE).containingSkill.getConsumption(), executer);
                    executer.setStamina(executer.getStamina() + consumption);
                    container.getDataManager().setData(CURRENTLY_ACTIVATED, true);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.FAILED);
                }
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }
}

