/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.brain.task.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.brain.task.BackUpIfTooCloseStopInaction;
import yesman.epicfight.world.entity.ai.brain.task.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomHumanoidMobPatch<T extends CreatureEntity>
extends HumanoidMobPatch<T> {
    private final MobPatchReloadListener.CustomHumanoidMobPatchProvider provider;

    public CustomHumanoidMobPatch(Faction faction, MobPatchReloadListener.CustomHumanoidMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
        this.weaponLivingMotions = this.provider.getHumanoidWeaponMotions();
        this.weaponAttackMotions = this.provider.getHumanoidCombatBehaviors();
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        boolean isUsingBrain;
        boolean bl = isUsingBrain = ((CreatureEntity)this.getOriginal()).func_213375_cj().field_218232_c.size() > 0;
        if (isUsingBrain) {
            if (!holdingRanedWeapon) {
                CombatBehaviors.Builder<HumanoidMobPatch<?>> builder2 = this.getHoldingItemWeaponMotionBuilder();
                if (builder2 != null) {
                    BrainRecomposer.replaceBehaviors(((CreatureEntity)this.original).func_213375_cj(), Activity.field_234621_k_, AttackTargetTask.class, new AnimatedCombatBehavior<CustomHumanoidMobPatch>(this, builder2.build(this)));
                }
                BrainRecomposer.replaceBehaviors(((CreatureEntity)this.original).func_213375_cj(), Activity.field_234621_k_, SupplementedTask.class, new SupplementedTask(entity -> entity.func_233634_a_(is -> is.getItem() instanceof CrossbowItem), new BackUpIfTooCloseStopInaction(5, 0.75f)));
                BrainRecomposer.replaceBehaviors(((CreatureEntity)this.original).func_213375_cj(), Activity.field_221365_a, WalkToTargetTask.class, new MoveToTargetSinkStopInaction());
            }
        } else if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<CustomHumanoidMobPatch>(this, builder.build(this)));
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.getOriginal(), this.provider.getChasingSpeed(), true));
        }
    }

    @Override
    protected void setWeaponMotions() {
        if (this.weaponAttackMotions == null) {
            super.setWeaponMotions();
        }
    }

    @Override
    protected void initAttributes() {
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.WEIGHT.get()).func_111128_a(((CreatureEntity)this.original).func_110148_a(Attributes.field_233818_a_).func_111125_b() * 2.0);
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        if (this.provider.getAttributeValues().containsKey(Attributes.field_233823_f_)) {
            ((CreatureEntity)this.original).func_110148_a(Attributes.field_233823_f_).func_111128_a(this.provider.getAttributeValues().get(Attributes.field_233823_f_).doubleValue());
        }
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
        if (((CreatureEntity)this.original).func_184587_cr()) {
            CapabilityItem activeItem = this.getHoldingItemCapability(((CreatureEntity)this.original).func_184600_cs());
            UseAction useAnim = ((CreatureEntity)this.original).func_184586_b(((CreatureEntity)this.original).func_184600_cs()).func_77975_n();
            UseAction secondUseAnim = activeItem.getUseAnimation(this);
            this.currentCompositeMotion = useAnim == UseAction.BLOCK || secondUseAnim == UseAction.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAction.BOW || useAnim == UseAction.SPEAR ? LivingMotions.AIM : (useAnim == UseAction.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = CrossbowItem.func_220012_d((ItemStack)((CreatureEntity)this.original).func_184614_ca()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((CreatureEntity)this.original).field_82175_bq && !((CreatureEntity)this.original).func_213374_dv().isPresent() ? LivingMotions.DIGGING : this.currentLivingMotion));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
                this.playReboundAnimation();
            }
        }
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return modelDB.get(this.provider.getModelLocation());
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

