/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomMobPatch<T extends CreatureEntity>
extends MobPatch<T> {
    private final MobPatchReloadListener.CustomMobPatchProvider provider;

    public CustomMobPatch(Faction faction, MobPatchReloadListener.CustomMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<CustomMobPatch>(this, this.provider.getCombatBehaviorsBuilder().build(this)));
        ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.getOriginal(), this.provider.getChasingSpeed(), true));
    }

    @Override
    protected void initAttributes() {
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.WEIGHT.get()).func_111128_a(((CreatureEntity)this.original).func_110148_a(Attributes.field_233818_a_).func_111125_b() * 2.0);
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(this.provider.getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        if (this.provider.getAttributeValues().containsKey(Attributes.field_233823_f_)) {
            ((CreatureEntity)this.original).func_110148_a(Attributes.field_233823_f_).func_111128_a(this.provider.getAttributeValues().get(Attributes.field_233823_f_).doubleValue());
        }
    }

    @Override
    public void initAnimator(ClientAnimator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return modelDB.get(this.provider.getModelLocation());
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

