/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;

public abstract class EntityPatch<T extends Entity> {
    protected T original;
    protected boolean initialized = false;

    public abstract void tick(LivingEvent.LivingUpdateEvent var1);

    protected abstract void clientTick(LivingEvent.LivingUpdateEvent var1);

    protected abstract void serverTick(LivingEvent.LivingUpdateEvent var1);

    public void onStartTracking(ServerPlayerEntity trackingPlayer) {
    }

    public void processSpawnData(ByteBuf buf) {
    }

    public void onConstructed(T entityIn) {
        this.original = entityIn;
    }

    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        this.initialized = true;
    }

    public final T getOriginal() {
        return this.original;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isLogicalClient() {
        return ((Entity)this.original).field_70170_p.func_201670_d();
    }

    public OpenMatrix4f getMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((Entity)this.original).field_70127_C, ((Entity)this.original).field_70125_A, ((Entity)this.original).field_70126_B, ((Entity)this.original).field_70177_z, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    public double getAngleTo(Entity entityIn) {
        Vector3d a = this.original.func_70040_Z();
        Vector3d b = new Vector3d(entityIn.func_226277_ct_() - this.original.func_226277_ct_(), entityIn.func_226278_cu_() - this.original.func_226278_cu_(), entityIn.func_226281_cx_() - this.original.func_226281_cx_()).func_72432_b();
        double cos = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.toDegrees(Math.acos(cos));
    }

    public double getAngleToHorizontal(Entity entityIn) {
        Vector3d a = this.original.func_70040_Z();
        Vector3d b = new Vector3d(entityIn.func_226277_ct_() - this.original.func_226277_ct_(), 0.0, entityIn.func_226281_cx_() - this.original.func_226281_cx_()).func_72432_b();
        double cos = a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
        return Math.toDegrees(Math.acos(cos));
    }

    public abstract OpenMatrix4f getModelMatrix(float var1);
}

