/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.Hand;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class HumanoidMobPatch<T extends CreatureEntity>
extends MobPatch<T> {
    protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> weaponLivingMotions;
    protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> weaponAttackMotions;

    public HumanoidMobPatch(Faction faction) {
        super(faction);
        this.setWeaponMotions();
    }

    @Override
    protected void initAI() {
        super.initAI();
        if (((CreatureEntity)this.original).func_184187_bx() != null && ((CreatureEntity)this.original).func_184187_bx() instanceof MobEntity) {
            this.setAIAsMounted(((CreatureEntity)this.original).func_184187_bx());
        } else {
            this.setAIAsInfantry(((CreatureEntity)this.original).func_184614_ca().func_77973_b() instanceof ShootableItem);
        }
    }

    @Override
    public void onStartTracking(ServerPlayerEntity trackingPlayer) {
        this.modifyLivingMotionByCurrentItem();
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, (Object)Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)LivingMotions.WALK, (Object)Animations.BIPED_WALK_TWOHAND), Pair.of((Object)LivingMotions.CHASE, (Object)Animations.BIPED_WALK_TWOHAND)})));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.AXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.HOE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.PICKAXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SHOVEL, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_DUAL_SWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_GREATSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.KATANA, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_KATANA));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.LONGSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_LONGSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TACHI, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TACHI));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SPEAR, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_SPEAR_TWOHAND));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.FIST, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.DAGGER, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_DAGGER, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TWOHAND_DAGGER));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.RANGED, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TRIDENT, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND));
    }

    protected CombatBehaviors.Builder<HumanoidMobPatch<?>> getHoldingItemWeaponMotionBuilder() {
        Style style;
        Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>> motionByStyle;
        CapabilityItem itemCap = this.getHoldingItemCapability(Hand.MAIN_HAND);
        if (this.weaponAttackMotions.containsKey(itemCap.getWeaponCategory()) && ((motionByStyle = this.weaponAttackMotions.get(itemCap.getWeaponCategory())).containsKey(style = itemCap.getStyle(this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            return motionByStyle.getOrDefault(style, motionByStyle.get(CapabilityItem.Styles.COMMON));
        }
        return null;
    }

    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, builder.build(this)));
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.getOriginal(), 1.0, true));
        }
    }

    public void setAIAsMounted(Entity ridingEntity) {
        if (this.isArmed() && ridingEntity instanceof AbstractHorseEntity) {
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, MobCombatBehaviors.MOUNT_HUMANOID_BEHAVIORS.build(this)));
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.getOriginal(), 1.0, true));
        }
    }

    protected final void commonMobAnimatorInit(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    protected final void commonAggresiveMobAnimatorInit(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.CHASE, Animations.BIPED_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, Hand hand) {
        this.initAI();
        if (hand == Hand.OFF_HAND) {
            if (!from.func_190926_b()) {
                from.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_111124_b(arg_0));
                from.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_111124_b(arg_0));
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.ARMOR_NEGATION.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.IMPACT.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).func_111124_b(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.MAX_STRIKES.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).func_111124_b(arg_0));
            }
            if (!to.func_190926_b()) {
                to.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get())).func_233767_b_(arg_0));
                to.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).func_233767_b_(arg_0));
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.ARMOR_NEGATION.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.IMPACT.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).func_233767_b_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)EpicFightAttributes.MAX_STRIKES.get()).forEach(arg_0 -> ((ModifiableAttributeInstance)((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).func_233767_b_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
    }

    public void modifyLivingMotionByCurrentItem() {
        Style style;
        Map<Style, Set<Pair<LivingMotion, StaticAnimation>>> mapByStyle;
        ((Animator)this.getAnimator()).resetMotions();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(Hand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(Hand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        offhandCap.getLivingMotionModifier(this, Hand.OFF_HAND).forEach(motionModifier::put);
        mainhandCap.getLivingMotionModifier(this, Hand.MAIN_HAND).forEach(motionModifier::put);
        for (Map.Entry entry : motionModifier.entrySet()) {
            ((Animator)this.getAnimator()).addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        if (this.weaponLivingMotions != null && this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((mapByStyle = this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle(this)) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set<Pair<LivingMotion, StaticAnimation>> animModifierSet = mapByStyle.getOrDefault(style, mapByStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair<LivingMotion, StaticAnimation> pair : animModifierSet) {
                this.animator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
            }
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((CreatureEntity)this.original).func_145782_y());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
    }

    public boolean isArmed() {
        Item heldItem = ((CreatureEntity)this.original).func_184614_ca().func_77973_b();
        return heldItem instanceof SwordItem || heldItem instanceof ToolItem || heldItem instanceof TridentItem;
    }

    @Override
    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
        if (this.original == null) {
            return;
        }
        if (!((CreatureEntity)this.original).field_70170_p.func_201670_d() && !((CreatureEntity)this.original).func_175446_cd()) {
            HashSet toRemove = Sets.newHashSet();
            this.selectGoalToRemove(toRemove);
            toRemove.forEach(arg_0 -> ((GoalSelector)((CreatureEntity)this.original).field_70714_bg).func_85156_a(arg_0));
            if (isMountOrDismount) {
                this.setAIAsMounted(ridingEntity);
            } else {
                this.setAIAsInfantry(((CreatureEntity)this.original).func_184614_ca().func_77973_b() instanceof ShootableItem);
            }
        }
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        if (((CreatureEntity)this.original).func_184187_bx() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.BIPED_KNOCKDOWN;
            }
            case FALL: {
                return Animations.BIPED_LANDING;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }
}

