/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributeSupplier;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public abstract class LivingEntityPatch<T extends LivingEntity>
extends EntityPatch<T> {
    public static final DataParameter<Float> STUN_SHIELD = new DataParameter(251, DataSerializers.field_187193_c);
    public static final DataParameter<Float> MAX_STUN_SHIELD = new DataParameter(252, DataSerializers.field_187193_c);
    private float stunTimeReduction;
    protected EntityState state = EntityState.DEFAULT;
    protected Animator animator;
    public LivingMotion currentLivingMotion = LivingMotions.IDLE;
    public LivingMotion currentCompositeMotion = LivingMotions.IDLE;
    public List<LivingEntity> currentlyAttackedEntity;
    protected Vector3d lastAttackPosition;

    @Override
    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        this.animator = EpicFightMod.getAnimator(this);
        this.animator.init();
        this.currentlyAttackedEntity = new ArrayList<LivingEntity>();
        ((LivingEntity)this.original).func_184212_Q().func_187214_a(STUN_SHIELD, (Object)Float.valueOf(0.0f));
        ((LivingEntity)this.original).func_184212_Q().func_187214_a(MAX_STUN_SHIELD, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        ((LivingEntity)this.original).func_233645_dx_().field_233777_d_ = new EpicFightAttributeSupplier(((LivingEntity)this.original).func_233645_dx_().field_233777_d_);
        this.initAttributes();
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void initAnimator(ClientAnimator var1);

    public abstract void updateMotion(boolean var1);

    public abstract <M extends Model> M getEntityModel(Models<M> var1);

    protected void initAttributes() {
        ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.WEIGHT.get()).func_111128_a(((LivingEntity)this.original).func_110148_a(Attributes.field_233818_a_).func_111125_b() * 2.0);
        ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111128_a(1.0);
        ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111128_a(0.0);
        ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(0.5);
    }

    @Override
    protected void clientTick(LivingEvent.LivingUpdateEvent event) {
    }

    @Override
    protected void serverTick(LivingEvent.LivingUpdateEvent event) {
        if (this.stunTimeReduction > 0.0f) {
            float stunArmor = this.getStunArmor();
            this.stunTimeReduction -= 0.05f * (1.1f - this.stunTimeReduction * this.stunTimeReduction) * (1.0f - stunArmor / (7.5f + stunArmor));
            this.stunTimeReduction = Math.max(0.0f, this.stunTimeReduction);
        }
    }

    @Override
    public void tick(LivingEvent.LivingUpdateEvent event) {
        this.animator.tick();
        if (this.isLogicalClient()) {
            this.clientTick(event);
        } else {
            this.serverTick(event);
        }
        if (((LivingEntity)this.original).field_70725_aQ == 19) {
            this.aboutToDeath();
        }
    }

    public void onDeath() {
        ((Animator)this.getAnimator()).playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public void updateEntityState() {
        this.state = this.animator.getEntityState();
    }

    public void cancelUsingItem() {
        ((LivingEntity)this.original).func_184602_cy();
        ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.original), (ItemStack)((LivingEntity)this.original).func_184607_cu(), (int)((LivingEntity)this.original).func_184605_cv());
    }

    public CapabilityItem getHoldingItemCapability(Hand hand) {
        if (hand == null) {
            return CapabilityItem.EMPTY;
        }
        return EpicFightCapabilities.getItemStackCapability(((LivingEntity)this.original).func_184586_b(hand));
    }

    public CapabilityItem getAdvancedHoldingItemCapability(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.getHoldingItemCapability(hand);
        }
        return this.isOffhandItemValid() ? this.getHoldingItemCapability(hand) : CapabilityItem.EMPTY;
    }

    public ExtendedDamageSource getDamageSource(ExtendedDamageSource.StunType stunType, StaticAnimation animation, Hand hand) {
        return ExtendedDamageSource.causeMobDamage((LivingEntity)this.original, stunType, animation);
    }

    public float getDamageTo(@Nullable Entity targetEntity, @Nullable ExtendedDamageSource source, Hand hand) {
        float damage = 0.0f;
        damage = hand == Hand.MAIN_HAND ? (float)((LivingEntity)this.original).func_233637_b_(Attributes.field_233823_f_) : (this.isOffhandItemValid() ? (float)((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_DAMAGE.get()) : (float)((LivingEntity)this.original).func_110148_a(Attributes.field_233823_f_).func_111125_b());
        return damage += EnchantmentHelper.func_152377_a((ItemStack)this.getValidItemInHand(hand), (CreatureAttribute)(targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).func_70668_bt() : CreatureAttribute.field_223222_a_));
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (this.getEntityState().invulnerableTo(damageSource)) {
            return new AttackResult(AttackResult.ResultType.FAILED, amount);
        }
        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
    }

    public AttackResult tryHarm(Entity target, ExtendedDamageSource damagesource, float amount) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)target.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        AttackResult result = entitypatch != null ? entitypatch.tryHurt((DamageSource)damagesource, amount) : new AttackResult(AttackResult.ResultType.SUCCESS, amount);
        return result;
    }

    public void onHurtSomeone(Entity target, Hand handIn, ExtendedDamageSource damagesource, float amount, boolean succeed) {
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.getValidItemInHand(handIn));
        if (target instanceof LivingEntity) {
            ((LivingEntity)this.getOriginal()).func_174815_a((LivingEntity)this.getOriginal(), target);
            if (j > 0 && !target.func_70027_ad()) {
                target.func_70015_d(j * 4);
            }
        }
    }

    public boolean onDrop(LivingDropsEvent event) {
        return false;
    }

    public void gatherDamageDealt(ExtendedDamageSource source, float amount) {
    }

    public void setStunReductionOnHit() {
        this.stunTimeReduction += Math.max((1.0f - this.stunTimeReduction) * 0.8f, 0.5f);
        this.stunTimeReduction = Math.min(1.0f, this.stunTimeReduction);
    }

    public float getStunTimeTimeReduction() {
        return this.stunTimeReduction;
    }

    public void knockBackEntity(Vector3d sourceLocation, float power) {
        double d1 = sourceLocation.func_82615_a() - ((LivingEntity)this.original).func_226277_ct_();
        double d0 = sourceLocation.func_82616_c() - ((LivingEntity)this.original).func_226281_cx_();
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((LivingEntity)this.original).func_70681_au().nextDouble() >= ((LivingEntity)this.original).func_233637_b_(Attributes.field_233820_c_)) {
            Vector3d vec = ((LivingEntity)this.original).func_213322_ci();
            ((LivingEntity)this.original).field_70160_al = true;
            float f = (float)Math.sqrt(d1 * d1 + d0 * d0);
            double x = vec.field_72450_a;
            double y = vec.field_72448_b;
            double z = vec.field_72449_c;
            x /= 2.0;
            z /= 2.0;
            x -= d1 / (double)f * (double)power;
            z -= d0 / (double)f * (double)power;
            if (!((LivingEntity)this.original).func_233570_aj_()) {
                y /= 2.0;
                if ((y += (double)power) > (double)0.4f) {
                    y = 0.4f;
                }
            }
            ((LivingEntity)this.original).func_213293_j(x, y, z);
            ((LivingEntity)this.original).field_70133_I = true;
        }
    }

    public float getStunArmor() {
        ModifiableAttributeInstance stunArmor = ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.STUN_ARMOR.get());
        return (float)(stunArmor == null ? 0.0 : stunArmor.func_111126_e());
    }

    public float getStunShield() {
        return ((Float)((LivingEntity)this.original).func_184212_Q().func_187225_a(STUN_SHIELD)).floatValue();
    }

    public void setStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).func_184212_Q().func_187227_b(STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getMaxStunShield() {
        return ((Float)((LivingEntity)this.original).func_184212_Q().func_187225_a(MAX_STUN_SHIELD)).floatValue();
    }

    public void setMaxStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).func_184212_Q().func_187227_b(MAX_STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getWeight() {
        return (float)((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.WEIGHT.get());
    }

    public void rotateTo(float degree, float limit, boolean synchronizeOld) {
        float amount;
        LivingEntity entity = (LivingEntity)this.getOriginal();
        for (amount = degree - entity.field_70177_z; amount < -180.0f; amount += 360.0f) {
        }
        while (amount > 180.0f) {
            amount -= 360.0f;
        }
        amount = MathHelper.func_76131_a((float)amount, (float)(-limit), (float)limit);
        float f1 = entity.field_70177_z + amount;
        if (synchronizeOld) {
            entity.field_70126_B = f1;
            entity.field_70758_at = f1;
            entity.field_70760_ar = f1;
        }
        entity.field_70177_z = f1;
        entity.field_70759_as = f1;
        entity.field_70761_aq = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.func_226277_ct_() - ((LivingEntity)this.original).func_226277_ct_();
        double d1 = target.func_226281_cx_() - ((LivingEntity)this.original).func_226281_cx_();
        float degree = -((float)Math.toDegrees(MathHelper.func_181159_b((double)d0, (double)d1)));
        this.rotateTo(degree, limit, partialSync);
    }

    public void playSound(SoundEvent sound, float pitchModifierMin, float pitchModifierMax) {
        this.playSound(sound, 1.0f, pitchModifierMin, pitchModifierMax);
    }

    public void playSound(SoundEvent sound, float volume, float pitchModifierMin, float pitchModifierMax) {
        float pitch = (((LivingEntity)this.original).func_70681_au().nextFloat() * 2.0f - 1.0f) * (pitchModifierMax - pitchModifierMin);
        if (!this.isLogicalClient()) {
            ((LivingEntity)this.original).field_70170_p.func_184148_a(null, ((LivingEntity)this.original).func_226277_ct_(), ((LivingEntity)this.original).func_226278_cu_(), ((LivingEntity)this.original).func_226281_cx_(), sound, ((LivingEntity)this.original).func_184176_by(), volume, 1.0f + pitch);
        } else {
            ((LivingEntity)this.original).field_70170_p.func_184134_a(((LivingEntity)this.original).func_226277_ct_(), ((LivingEntity)this.original).func_226278_cu_(), ((LivingEntity)this.original).func_226281_cx_(), sound, ((LivingEntity)this.original).func_184176_by(), volume, 1.0f + pitch, false);
        }
    }

    public LivingEntity getTarget() {
        return ((LivingEntity)this.original).func_110144_aD();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
        float pitch = -((LivingEntity)this.getOriginal()).func_195050_f(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return MathHelper.func_76131_a((float)correct, (float)-30.0f, (float)30.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public OpenMatrix4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.state.inaction()) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.lerpBetween(((LivingEntity)this.original).field_70760_ar, ((LivingEntity)this.original).field_70761_aq, partialTicks);
            float f1 = MathUtils.lerpBetween(((LivingEntity)this.original).field_70758_at, ((LivingEntity)this.original).field_70759_as, partialTicks);
            f2 = f1 - f;
            if (((LivingEntity)this.original).func_184187_bx() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((LivingEntity)this.original).field_70127_C, ((LivingEntity)this.original).field_70125_A, f2, f2, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        float scale;
        float f = scale = ((LivingEntity)this.original).func_70631_g_() ? 0.5f : 1.0f;
        if (((LivingEntity)this.original).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((LivingEntity)this.original).func_184187_bx();
            prevYRot = ridingEntity.field_70760_ar;
            yRot = ridingEntity.field_70761_aq;
        } else {
            prevYRot = this.isLogicalClient() ? ((LivingEntity)this.original).field_70760_ar : ((LivingEntity)this.original).field_70177_z;
            yRot = this.isLogicalClient() ? ((LivingEntity)this.original).field_70761_aq : ((LivingEntity)this.original).field_70177_z;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, scale, scale, scale);
    }

    public void reserveAnimation(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPPlayAnimation(animation, ((LivingEntity)this.original).func_145782_y(), 0.0f), this.original);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier) {
        this.playAnimationSynchronized(animation, convertTimeModifier, SPPlayAnimation::new);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, AnimationPacketProvider packetProvider) {
        this.animator.playAnimation(animation, convertTimeModifier);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(packetProvider.get(animation, convertTimeModifier, this), this.original);
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    public void resetSize(EntitySize size) {
        EntitySize entitysize1;
        EntitySize entitysize = ((LivingEntity)this.original).field_213325_aI;
        ((LivingEntity)this.original).field_213325_aI = entitysize1 = size;
        if (entitysize1.field_220315_a < entitysize.field_220315_a) {
            double d0 = (double)entitysize1.field_220315_a / 2.0;
            ((LivingEntity)this.original).func_174826_a(new AxisAlignedBB(((LivingEntity)this.original).func_226277_ct_() - d0, ((LivingEntity)this.original).func_226278_cu_(), ((LivingEntity)this.original).func_226281_cx_() - d0, ((LivingEntity)this.original).func_226277_ct_() + d0, ((LivingEntity)this.original).func_226278_cu_() + (double)entitysize1.field_220316_b, ((LivingEntity)this.original).func_226281_cx_() + d0));
        } else {
            AxisAlignedBB axisalignedbb = ((LivingEntity)this.original).func_174813_aQ();
            ((LivingEntity)this.original).func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entitysize1.field_220315_a, axisalignedbb.field_72338_b + (double)entitysize1.field_220316_b, axisalignedbb.field_72339_c + (double)entitysize1.field_220315_a));
            if (entitysize1.field_220315_a > entitysize.field_220315_a && !((LivingEntity)this.original).field_70170_p.func_201670_d()) {
                float f = entitysize.field_220315_a - entitysize1.field_220315_a;
                ((LivingEntity)this.original).func_213315_a(MoverType.SELF, new Vector3d((double)f, 0.0, (double)f));
            }
        }
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, Hand hand) {
    }

    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
    }

    public void onAttackBlocked(HurtEvent.Pre hurtEvent, LivingEntityPatch<?> opponent) {
    }

    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public ClientAnimator getClientAnimator() {
        return (ClientAnimator)this.getAnimator();
    }

    public ServerAnimator getServerAnimator() {
        return (ServerAnimator)this.getAnimator();
    }

    public abstract StaticAnimation getHitAnimation(ExtendedDamageSource.StunType var1);

    public void aboutToDeath() {
    }

    public SoundEvent getWeaponHitSound(Hand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(Hand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getSmashingSound();
    }

    public HitParticleType getWeaponHitParticle(Hand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public Collider getColliderMatching(Hand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public int getMaxStrikes(Hand hand) {
        return (int)(hand == Hand.MAIN_HAND ? ((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.MAX_STRIKES.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()) : ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.MAX_STRIKES.get()).func_111125_b()));
    }

    public float getArmorNegation(Hand hand) {
        return (float)(hand == Hand.MAIN_HAND ? ((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()) : ((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).func_111125_b()));
    }

    public float getImpact(Hand hand) {
        float impact;
        int i = 0;
        if (hand == Hand.MAIN_HAND) {
            impact = (float)((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.IMPACT.get());
            i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)((LivingEntity)this.getOriginal()).func_184614_ca());
        } else if (this.isOffhandItemValid()) {
            impact = (float)((LivingEntity)this.original).func_233637_b_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)((LivingEntity)this.getOriginal()).func_184592_cb());
        } else {
            impact = (float)((LivingEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111125_b();
        }
        return impact * (1.0f + (float)i * 0.12f);
    }

    public ItemStack getValidItemInHand(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return ((LivingEntity)this.original).func_184586_b(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).func_184586_b(hand) : ItemStack.field_190927_a;
    }

    public boolean isOffhandItemValid() {
        return this.getHoldingItemCapability(Hand.MAIN_HAND).checkOffhandValid(this);
    }

    public boolean isTeammate(Entity entityIn) {
        if (((LivingEntity)this.original).func_184187_bx() != null && ((LivingEntity)this.original).func_184187_bx().equals((Object)entityIn)) {
            return true;
        }
        if (this.isRideOrBeingRidden(entityIn)) {
            return true;
        }
        return ((LivingEntity)this.original).func_184191_r(entityIn) && ((LivingEntity)this.original).func_96124_cp() != null && !((LivingEntity)this.original).func_96124_cp().func_96665_g();
    }

    public Vector3d getLastAttackPosition() {
        return this.lastAttackPosition;
    }

    public void setLastAttackPosition() {
        this.lastAttackPosition = ((LivingEntity)this.original).func_213303_ch();
    }

    private boolean isRideOrBeingRidden(Entity entityIn) {
        LivingEntity orgEntity = (LivingEntity)this.getOriginal();
        for (Entity passanger : orgEntity.func_184188_bt()) {
            if (!passanger.equals((Object)entityIn)) continue;
            return true;
        }
        for (Entity passanger : entityIn.func_184188_bt()) {
            if (!passanger.equals((Object)orgEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstPerson() {
        return false;
    }

    public boolean shouldSkipRender() {
        return false;
    }

    public boolean shouldBlockMoving() {
        return false;
    }

    public float getYRotLimit() {
        return 20.0f;
    }

    public EntityState getEntityState() {
        return this.state;
    }

    public LivingMotion getCurrentLivingMotion() {
        return this.currentLivingMotion;
    }

    @FunctionalInterface
    public static interface AnimationPacketProvider {
        public SPPlayAnimation get(StaticAnimation var1, float var2, LivingEntityPatch<?> var3);
    }
}

