/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class MobPatch<T extends MobEntity>
extends LivingEntityPatch<T> {
    protected final Faction mobFaction;

    public MobPatch() {
        this.mobFaction = Faction.NEUTRAL;
    }

    public MobPatch(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        if (!((MobEntity)entityIn).field_70170_p.func_201670_d() && !((MobEntity)this.original).func_175446_cd()) {
            this.initAI();
        }
    }

    protected void initAI() {
        HashSet toRemove = Sets.newHashSet();
        this.selectGoalToRemove(toRemove);
        toRemove.forEach(arg_0 -> ((GoalSelector)((MobEntity)this.original).field_70714_bg).func_85156_a(arg_0));
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (PrioritizedGoal wrappedGoal : ((MobEntity)this.original).field_70714_bg.field_220892_d) {
            Goal goal = wrappedGoal.func_220772_j();
            if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal)) continue;
            toRemove.add(goal);
        }
    }

    protected final void commonMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((MobEntity)this.original).func_110143_aJ() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((MobEntity)this.original).func_184187_bx() != null ? LivingMotions.MOUNT : (((MobEntity)this.original).func_213322_ci().field_72448_b < (double)-0.55f ? LivingMotions.FALL : (((MobEntity)this.original).field_70721_aZ > 0.01f ? LivingMotions.WALK : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((MobEntity)this.original).func_110143_aJ() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((MobEntity)this.original).func_184187_bx() != null ? LivingMotions.MOUNT : (((MobEntity)this.original).func_213322_ci().field_72448_b < (double)-0.55f ? LivingMotions.FALL : (((MobEntity)this.original).field_70721_aZ > 0.01f ? (((MobEntity)this.original).func_213398_dR() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveRangedMobUpdateMotion(boolean considerInaction) {
        this.commonAggressiveMobUpdateMotion(considerInaction);
        UseAction useAction = ((MobEntity)this.original).func_184586_b(((MobEntity)this.original).func_184600_cs()).func_77975_n();
        if (((MobEntity)this.original).func_184587_cr()) {
            this.currentCompositeMotion = useAction == UseAction.CROSSBOW ? LivingMotions.RELOAD : LivingMotions.AIM;
        } else if (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation()) {
            this.currentCompositeMotion = LivingMotions.NONE;
        }
        if (CrossbowItem.func_220012_d((ItemStack)((MobEntity)this.original).func_184614_ca())) {
            this.currentCompositeMotion = LivingMotions.AIM;
        } else if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
            this.playReboundAnimation();
        }
    }

    @Override
    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
        if (((MobEntity)this.original).func_233645_dx_().func_233790_b_((Attribute)EpicFightAttributes.STUN_ARMOR.get())) {
            if (fromCap != null) {
                ((MobEntity)this.original).func_233645_dx_().func_233785_a_(fromCap.getAttributeModifiers(slotType, this));
            }
            if (toCap != null) {
                ((MobEntity)this.original).func_233645_dx_().func_233793_b_(toCap.getAttributeModifiers(slotType, this));
            }
        }
    }

    @Override
    public boolean isTeammate(Entity entityIn) {
        EntityPatch cap = (EntityPatch)entityIn.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null && cap instanceof MobPatch && ((MobPatch)cap).mobFaction.equals((Object)this.mobFaction)) {
            Optional<LivingEntity> opt = Optional.ofNullable(this.getTarget());
            return opt.map(attackTarget -> !attackTarget.func_70028_i(entityIn)).orElse(true);
        }
        return super.isTeammate(entityIn);
    }

    @Override
    public LivingEntity getTarget() {
        return ((MobEntity)this.original).func_70638_az();
    }

    public void setAttakTargetSync(LivingEntity entityIn) {
        if (!((MobEntity)this.original).field_70170_p.func_201670_d()) {
            ((MobEntity)this.original).func_70624_b(entityIn);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetAttackTarget(((MobEntity)this.original).func_145782_y(), entityIn != null ? entityIn.func_145782_y() : -1), this.original);
        }
    }

    @Override
    public float getAttackDirectionPitch() {
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null) {
            float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
            Vector3d target = attackTarget.func_174824_e(partialTicks);
            Vector3d vector3d = ((MobEntity)this.original).func_174824_e(partialTicks);
            double d0 = target.field_72450_a - vector3d.field_72450_a;
            double d1 = target.field_72448_b - vector3d.field_72448_b;
            double d2 = target.field_72449_c - vector3d.field_72449_c;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            return MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch();
    }
}

