/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.entity.AreaEffectBreath;

public class DragonAirstrikePhase
extends PatchedDragonPhase {
    private Vector3d startpos;
    private boolean isActuallyAttacking;

    public DragonAirstrikePhase(EnderDragonEntity dragon) {
        super(dragon);
    }

    public void func_188660_d() {
        this.startpos = this.field_188661_a.func_213303_ch();
        this.isActuallyAttacking = false;
        this.field_188661_a.field_70170_p.func_184134_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_(), SoundEvents.field_187525_aO, this.field_188661_a.func_184176_by(), 5.0f, 0.8f + this.field_188661_a.func_70681_au().nextFloat() * 0.3f, false);
    }

    public void func_188658_e() {
        this.dragonpatch.setAttakTargetSync(null);
        if (this.dragonpatch.isLogicalClient()) {
            Minecraft.func_71410_x().func_147118_V().func_195478_a(EpicFightSounds.ENDER_DRAGON_BREATH.func_187503_a(), SoundCategory.HOSTILE);
            this.field_188661_a.field_70170_p.func_184134_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_(), EpicFightSounds.ENDER_DRAGON_BREATH_FINALE, this.field_188661_a.func_184176_by(), 5.0f, 1.0f, false);
        }
    }

    @Override
    public void func_188657_b() {
        super.func_188657_b();
        Vector3d dragonpos = this.field_188661_a.func_213303_ch();
        OpenMatrix4f mouthpos = Animator.getBindedJointTransformByName(((Animator)this.dragonpatch.getAnimator()).getPose(1.0f), this.dragonpatch.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature(), "Mouth_Upper");
        float f = (float)this.field_188661_a.func_70974_a(7, 1.0f)[0];
        float f1 = (float)(this.field_188661_a.func_70974_a(5, 1.0f)[1] - this.field_188661_a.func_70974_a(10, 1.0f)[1]);
        float f2 = MathHelper.func_226168_l_((double)(this.field_188661_a.func_70974_a(5, 1.0f)[0] - this.field_188661_a.func_70974_a(10, 1.0f)[0]));
        OpenMatrix4f modelMatrix = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f1, f1, f, f, 1.0f, 1.0f, 1.0f, 1.0f).rotateDeg(-f2 * 1.5f, Vec3f.Z_AXIS);
        mouthpos.mulFront(modelMatrix);
        if (this.field_188661_a.func_70638_az() != null) {
            Vector3d vec31 = this.field_188661_a.func_70638_az().func_213303_ch().func_72441_c(0.0, 12.0, 0.0);
            if (!this.isActuallyAttacking && vec31.func_178788_d(this.field_188661_a.func_213303_ch()).func_189985_c() < 900.0) {
                this.field_188661_a.field_70170_p.func_184134_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_(), EpicFightSounds.ENDER_DRAGON_BREATH, this.field_188661_a.func_184176_by(), 5.0f, 1.0f, false);
                this.isActuallyAttacking = true;
            }
        }
        if (this.isActuallyAttacking) {
            for (int i = 0; i < 60; ++i) {
                Vec3f particleDelta = new Vec3f(0.0f, -1.0f, 0.0f);
                float xDeg = this.field_188661_a.func_70681_au().nextFloat() * 60.0f - 30.0f;
                float zDeg = this.field_188661_a.func_70681_au().nextFloat() * 60.0f - 30.0f;
                float speed = Math.min((60.0f - (Math.abs(xDeg) + Math.abs(zDeg))) / 20.0f, 1.0f);
                OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(xDeg, Vec3f.X_AXIS), particleDelta, particleDelta);
                OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(zDeg, Vec3f.Z_AXIS), particleDelta, particleDelta);
                particleDelta.scale(speed);
                this.field_188661_a.field_70170_p.func_195589_b((IParticleData)EpicFightParticles.BREATH_FLAME.get(), (double)mouthpos.m30 + dragonpos.field_72450_a, (double)mouthpos.m31 + dragonpos.field_72448_b, (double)mouthpos.m32 + dragonpos.field_72449_c, (double)particleDelta.x, (double)particleDelta.y, (double)particleDelta.z);
            }
        }
    }

    public void func_188659_c() {
        LivingEntity target = this.field_188661_a.func_70638_az();
        if (target == null) {
            this.field_188661_a.func_184670_cT().func_188758_a(PatchedPhases.FLYING);
        } else if (this.isValidTarget(target)) {
            Vector3d startToDragon = this.field_188661_a.func_213303_ch().func_178788_d(this.startpos);
            Vector3d startToTarget = target.func_213303_ch().func_178788_d(this.startpos);
            if (MathUtils.horizontalDistanceSqr(startToDragon) < MathUtils.horizontalDistanceSqr(startToTarget)) {
                Vector3d vec31 = target.func_213303_ch().func_72441_c(0.0, 12.0, 0.0);
                if (!this.isActuallyAttacking && vec31.func_178788_d(this.field_188661_a.func_213303_ch()).func_189985_c() < 900.0) {
                    this.isActuallyAttacking = true;
                }
                double d8 = vec31.field_72450_a - this.field_188661_a.func_226277_ct_();
                double d9 = vec31.field_72448_b - this.field_188661_a.func_226278_cu_();
                double d10 = vec31.field_72449_c - this.field_188661_a.func_226281_cx_();
                float f5 = this.func_188651_f();
                double d4 = Math.sqrt(d8 * d8 + d10 * d10);
                if (d4 > 0.0) {
                    d9 = MathHelper.func_151237_a((double)(d9 / d4), (double)(-f5), (double)f5);
                }
                this.field_188661_a.func_213317_d(this.field_188661_a.func_213322_ci().func_72441_c(0.0, d9 * 0.1, 0.0));
                this.field_188661_a.field_70177_z = MathHelper.func_76142_g((float)this.field_188661_a.field_70177_z);
                Vector3d vec32 = vec31.func_178786_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_()).func_72432_b();
                Vector3d vec33 = new Vector3d((double)MathHelper.func_76126_a((float)(this.field_188661_a.field_70177_z * ((float)Math.PI / 180))), this.field_188661_a.func_213322_ci().field_72448_b, (double)(-MathHelper.func_76134_b((float)(this.field_188661_a.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                float f6 = Math.max(((float)vec33.func_72430_b(vec32) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs(d8) > (double)1.0E-5f || Math.abs(d10) > (double)1.0E-5f) {
                    double dx = target.func_226277_ct_() - this.field_188661_a.func_226277_ct_();
                    double dz = target.func_226281_cx_() - this.field_188661_a.func_226281_cx_();
                    float yRot = 180.0f - (float)Math.toDegrees(MathHelper.func_181159_b((double)dx, (double)dz));
                    this.field_188661_a.field_70177_z = MathUtils.rotlerp(this.field_188661_a.field_70177_z, yRot, 6.0f);
                    double speed = (-0.5 - 1.0 / (1.0 + Math.pow(Math.E, -(d4 / 10.0 - 4.0)))) * (double)f6;
                    Vector3d forward = Vector3d.func_189984_a((Vector2f)this.field_188661_a.func_189653_aC()).func_186678_a(speed);
                    this.field_188661_a.func_213315_a(MoverType.SELF, forward);
                }
                if (this.field_188661_a.field_70994_bF) {
                    this.field_188661_a.func_213315_a(MoverType.SELF, this.field_188661_a.func_213322_ci().func_186678_a((double)0.8f));
                } else {
                    this.field_188661_a.func_213315_a(MoverType.SELF, this.field_188661_a.func_213322_ci());
                }
                Vector3d vec34 = this.field_188661_a.func_213322_ci().func_72432_b();
                double d6 = 0.8 + 0.15 * (vec34.func_72430_b(vec33) + 1.0) / 2.0;
                this.field_188661_a.func_213317_d(this.field_188661_a.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
                if (this.isActuallyAttacking && this.field_188661_a.field_70173_aa % 5 == 0) {
                    Vector3d createpos = this.field_188661_a.func_213303_ch().func_178787_e(this.field_188661_a.func_70040_Z().func_186678_a(-4.5));
                    AreaEffectBreath breatharea = new AreaEffectBreath(this.field_188661_a.field_70170_p, createpos.field_72450_a, createpos.field_72448_b, createpos.field_72449_c);
                    breatharea.func_184481_a((LivingEntity)this.field_188661_a);
                    breatharea.func_184485_d(0);
                    breatharea.func_184483_a(0.5f);
                    breatharea.func_184486_b(15);
                    breatharea.func_184487_c(0.2f);
                    breatharea.func_184496_a(new EffectInstance(Effects.field_76433_i, 1, 1));
                    breatharea.func_213293_j(0.0, -1.0, 0.0);
                    this.field_188661_a.field_70170_p.func_217376_c((Entity)breatharea);
                }
            } else {
                this.field_188661_a.func_184670_cT().func_188758_a(PatchedPhases.FLYING);
            }
        } else {
            this.field_188661_a.func_184670_cT().func_188758_a(PatchedPhases.FLYING);
        }
    }

    public boolean isActuallyAttacking() {
        return this.isActuallyAttacking;
    }

    public float func_188651_f() {
        return 2.0f;
    }

    public PhaseType<DragonAirstrikePhase> func_188652_i() {
        return PatchedPhases.AIRSTRIKE;
    }
}

