/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

public class DragonCrystalLinkPhase
extends PatchedDragonPhase {
    public static final float STUN_SHIELD_AMOUNT = 20.0f;
    public static final int CHARGING_TICK = 158;
    private int chargingCount;
    private EnderCrystalEntity linkingCrystal;

    public DragonCrystalLinkPhase(EnderDragonEntity dragon) {
        super(dragon);
    }

    public void func_188660_d() {
        ((Animator)this.dragonpatch.getAnimator()).playAnimation(Animations.DRAGON_CRYSTAL_LINK, 0.0f);
        this.field_188661_a.field_70170_p.func_184134_a(this.field_188661_a.func_226277_ct_(), this.field_188661_a.func_226278_cu_(), this.field_188661_a.func_226281_cx_(), EpicFightSounds.ENDER_DRAGON_CRYSTAL_LINK, this.field_188661_a.func_184176_by(), 10.0f, 1.0f, false);
        BlockPos blockpos = this.field_188661_a.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vector3i)EndPodiumFeature.field_186139_a));
        List list = this.field_188661_a.field_70170_p.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(blockpos).func_186662_g(200.0));
        EnderCrystalEntity nearestCrystal = null;
        double d0 = Double.MAX_VALUE;
        for (EnderCrystalEntity endcrystal : list) {
            double d1 = endcrystal.func_70068_e((Entity)this.field_188661_a);
            if (!(d1 < d0)) continue;
            d0 = d1;
            nearestCrystal = endcrystal;
        }
        this.linkingCrystal = nearestCrystal;
        this.chargingCount = 158;
        if (this.dragonpatch.isLogicalClient()) {
            double x = -45.0;
            double z = 0.0;
            Vector3d correction = this.field_188661_a.func_70040_Z().func_216372_d(2.0, 0.0, 2.0).func_178786_a(0.0, 2.0, 0.0);
            Vector3d spawnPosition = this.field_188661_a.func_213303_ch().func_178788_d(correction);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.field_188661_a.field_70170_p.func_195589_b((IParticleData)EpicFightParticles.FORCE_FIELD.get(), spawnPosition.field_72450_a, spawnPosition.field_72448_b, spawnPosition.field_72449_c, x + 90.0 * (double)i, Double.longBitsToDouble(this.field_188661_a.func_145782_y()), z + 90.0 * (double)j);
                }
            }
        } else if (!this.dragonpatch.isLogicalClient()) {
            int shieldCorrection = this.getPlayersNearbyWithin(100.0).size() - 1;
            float stunShield = 20.0f + 15.0f * (float)shieldCorrection;
            this.dragonpatch.setMaxStunShield(stunShield);
            this.dragonpatch.setStunShield(stunShield);
        }
    }

    public void func_188658_e() {
        BlockPos blockpos = this.linkingCrystal.func_233580_cy_();
        this.field_188661_a.field_70992_bH = null;
        this.linkingCrystal = null;
        if (!this.dragonpatch.isLogicalClient()) {
            this.field_188661_a.field_70170_p.func_217385_a((Entity)null, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 6.0f, Explosion.Mode.DESTROY);
        }
    }

    public float func_221113_a(DamageSource damagesource, float amount) {
        if (damagesource instanceof ExtendedDamageSource) {
            float impact = ((ExtendedDamageSource)damagesource).getImpact();
            this.dragonpatch.setStunShield(this.dragonpatch.getStunShield() - impact);
        }
        return amount;
    }

    @Override
    public void func_188657_b() {
        super.func_188657_b();
        this.field_188661_a.field_184678_bK = 200;
        --this.chargingCount;
        this.field_188661_a.field_70992_bH = this.linkingCrystal;
    }

    public void func_188659_c() {
        --this.chargingCount;
        this.field_188661_a.field_70757_a = 0;
        if (this.chargingCount > 0) {
            this.field_188661_a.func_70606_j(this.field_188661_a.func_110143_aJ() + 0.5f);
        }
    }

    public int getChargingCount() {
        return this.chargingCount;
    }

    public EnderCrystalEntity getLinkingCrystal() {
        return this.linkingCrystal;
    }

    public boolean func_188654_a() {
        return true;
    }

    public PhaseType<DragonCrystalLinkPhase> func_188652_i() {
        return PatchedPhases.CRYSTAL_LINK;
    }
}

