/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CreeperSwellStoppableGoal;

public class CreeperPatch
extends MobPatch<CreeperEntity> {
    public CreeperPatch() {
        super(Faction.NEUTRAL);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((CreeperEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.STUN_ARMOR.get()).func_111128_a(1.0);
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (PrioritizedGoal wrappedGoal : ((CreeperEntity)this.original).field_70714_bg.field_220892_d) {
            Goal goal = wrappedGoal.func_220772_j();
            if (!(goal instanceof CreeperSwellGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((CreeperEntity)this.original).field_70714_bg.func_75776_a(2, (Goal)new CreeperSwellStoppableGoal(this, (CreeperEntity)this.original));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.CREEPER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.CREEPER_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.CREEPER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        if (this.isLogicalClient()) {
            float f = ((CreeperEntity)this.original).func_70831_j(partialTicks);
            float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            OpenMatrix4f.scale(new Vec3f(f2, f3, f2), mat, mat);
        }
        return mat;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        if (stunType == ExtendedDamageSource.StunType.LONG) {
            return Animations.CREEPER_HIT_LONG;
        }
        return Animations.CREEPER_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.creeper;
    }
}

