/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.brain.task.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.brain.task.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class PiglinPatch
extends HumanoidMobPatch<PiglinEntity> {
    public PiglinPatch() {
        super(Faction.PIGLINS);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((PiglinEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.IMPACT.get()).func_111128_a(1.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.PIGLIN_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        clientAnimator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        clientAnimator.addLivingAnimation(LivingMotions.CELEBRATE, EpicFightMod.getInstance().animationManager.findAnimationById("epicfight".hashCode(), Animations.PIGLIN_CELEBRATE1.getId() + ((PiglinEntity)this.original).func_70681_au().nextInt(3)));
        clientAnimator.addLivingAnimation(LivingMotions.ADMIRE, Animations.PIGLIN_ADMIRE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.PIGLIN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.CHASE, Animations.PIGLIN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.PIGLIN_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.RELOAD, Animations.BIPED_CROSSBOW_RELOAD);
        clientAnimator.addLivingAnimation(LivingMotions.AIM, Animations.BIPED_CROSSBOW_AIM);
        clientAnimator.addLivingAnimation(LivingMotions.SHOT, Animations.BIPED_CROSSBOW_SHOT);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void onStartTracking(ServerPlayerEntity trackingPlayer) {
        if (((PiglinEntity)this.original).func_70631_g_()) {
            SPSpawnData packet = new SPSpawnData(((PiglinEntity)this.original).func_145782_y());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer);
        }
        super.onStartTracking(trackingPlayer);
    }

    @Override
    public void processSpawnData(ByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_RUN);
        animator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((PiglinEntity)this.getOriginal()).func_184592_cb().func_77973_b().func_206844_a((ITag)ItemTags.field_232903_N_)) {
            this.currentLivingMotion = LivingMotions.ADMIRE;
        } else if (((PiglinEntity)this.original).func_234425_eN_()) {
            this.currentLivingMotion = LivingMotions.CELEBRATE;
        } else {
            super.commonAggressiveRangedMobUpdateMotion(considerInaction);
        }
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.piglin;
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            BrainRecomposer.replaceBehavior(((PiglinEntity)this.original).func_213375_cj(), Activity.field_234621_k_, 13, AttackTargetTask.class, new AnimatedCombatBehavior<PiglinPatch>(this, builder.build(this)));
        }
        BrainRecomposer.replaceBehavior(((PiglinEntity)this.original).func_213375_cj(), Activity.field_234621_k_, 11, SupplementedTask.class, new SupplementedTask(e -> e.func_233634_a_(item -> item instanceof CrossbowItem), (Task)new AttackStrafingTask(5, 0.75f)));
        BrainRecomposer.replaceBehavior(((PiglinEntity)this.original).func_213375_cj(), Activity.field_221365_a, 1, WalkToTargetTask.class, new MoveToTargetSinkStopInaction());
        BrainRecomposer.removeBehavior(((PiglinEntity)this.original).func_213375_cj(), Activity.field_234622_l_, 15, FirstShuffledTask.class);
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }
}

