/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class SkeletonPatch<T extends CreatureEntity>
extends HumanoidMobPatch<T> {
    public SkeletonPatch() {
        super(Faction.UNDEAD);
    }

    public SkeletonPatch(Faction faction) {
        super(faction);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        super.commonAggresiveMobAnimatorInit(clientAnimator);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, (Object)Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)LivingMotions.CHASE, (Object)Animations.WITHER_SKELETON_CHASE)})));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.SKELETON_SWORD));
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<SkeletonPatch>(this, builder.build(this)));
            ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.original, 1.2, true));
        }
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.skeleton;
    }
}

