/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class SpiderPatch<T extends CreatureEntity>
extends MobPatch<T> {
    public SpiderPatch() {
        super(Faction.NEUTRAL);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((CreatureEntity)this.original).field_70714_bg.func_75776_a(0, new AnimatedAttackGoal<SpiderPatch>(this, MobCombatBehaviors.SPIDER.build(this)));
        ((CreatureEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new TargetChasingGoal(this, (CreatureEntity)this.original, 1.0, false));
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        for (PrioritizedGoal wrappedGoal : ((CreatureEntity)this.original).field_70714_bg.field_220892_d) {
            Goal goal = wrappedGoal.func_220772_j();
            if (!(goal instanceof LeapAtTargetGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.SPIDER_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.SPIDER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.SPIDER_CRAWL);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return Animations.SPIDER_HIT;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return SoundEvents.field_187821_fM;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.spider;
    }
}

