/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;

public class VexPatch
extends MobPatch<VexEntity> {
    public VexPatch() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((VexEntity)this.original).field_70714_bg.func_75776_a(0, (Goal)new ChargeAttackGoal());
        ((VexEntity)this.original).field_70714_bg.func_75776_a(1, (Goal)new StopStandGoal());
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        super.selectGoalToRemove(toRemove);
        Iterator iterator = ((VexEntity)this.original).field_70714_bg.field_220892_d.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (index == 1) {
                toRemove.add(inner);
                break;
            }
            ++index;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.VEX_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.VEX_FLIPPING);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((VexEntity)this.original).func_110143_aJ() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        } else {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        }
    }

    @Override
    public void onAttackBlocked(HurtEvent.Pre hurtEvent, LivingEntityPatch<?> opponent) {
        Vector3d vec3d = ((LivingEntity)opponent.getOriginal()).func_174824_e(1.0f).func_178787_e(((LivingEntity)opponent.getOriginal()).func_70040_Z());
        ((VexEntity)this.original).func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        this.playAnimationSynchronized(Animations.VEX_NEUTRALIZED, 0.0f);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.vex;
    }

    @Override
    public StaticAnimation getHitAnimation(ExtendedDamageSource.StunType stunType) {
        return Animations.VEX_HIT;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getModelMatrix(partialTicks).scale(0.4f, 0.4f, 0.4f);
    }

    class ChargeAttackGoal
    extends Goal {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (((VexEntity)VexPatch.this.original).func_70638_az() != null && !VexPatch.this.getEntityState().inaction() && ((VexEntity)VexPatch.this.original).func_70681_au().nextInt(10) == 0) {
                double distance = ((VexEntity)VexPatch.this.original).func_70068_e((Entity)((VexEntity)VexPatch.this.original).func_70638_az());
                return distance < 50.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.chargingCounter > 0;
        }

        public void func_75249_e() {
            ((VexEntity)VexPatch.this.original).func_70605_aq().func_75642_a(((VexEntity)VexPatch.this.original).func_226277_ct_(), ((VexEntity)VexPatch.this.original).func_226278_cu_(), ((VexEntity)VexPatch.this.original).func_226281_cx_(), 0.25);
            VexPatch.this.playAnimationSynchronized(Animations.VEX_CHARGE, 0.0f);
            ((VexEntity)VexPatch.this.original).func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
            ((VexEntity)VexPatch.this.original).func_190648_a(true);
            this.chargingCounter = 20;
        }

        public void func_75251_c() {
            ((VexEntity)VexPatch.this.original).func_190648_a(false);
        }

        public void func_75246_d() {
            --this.chargingCounter;
        }
    }

    class StopStandGoal
    extends Goal {
        public StopStandGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return VexPatch.this.getEntityState().inaction();
        }

        public void func_75249_e() {
            ((VexEntity)VexPatch.this.original).func_70605_aq().func_75642_a(((VexEntity)VexPatch.this.original).func_226277_ct_(), ((VexEntity)VexPatch.this.original).func_226278_cu_(), ((VexEntity)VexPatch.this.original).func_226281_cx_(), 0.25);
        }
    }
}

