/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.mob.SkeletonPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class WitherSkeletonPatch<T extends CreatureEntity>
extends SkeletonPatch<T> {
    public WitherSkeletonPatch() {
        super(Faction.WITHER);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((CreatureEntity)this.original).func_110148_a((Attribute)EpicFightAttributes.STUN_ARMOR.get()).func_111128_a(6.0);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, (Object)Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)LivingMotions.CHASE, (Object)Animations.WITHER_SKELETON_CHASE), Pair.of((Object)LivingMotions.WALK, (Object)Animations.WITHER_SKELETON_WALK), Pair.of((Object)LivingMotions.IDLE, (Object)Animations.WITHER_SKELETON_IDLE)})));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.SKELETON_SWORD));
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    @Override
    public void onHurtSomeone(Entity target, Hand handIn, ExtendedDamageSource source, float amount, boolean succeed) {
        if (succeed && target instanceof LivingEntity && ((CreatureEntity)this.original).func_70681_au().nextInt(10) == 0) {
            ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_82731_v, 200));
        }
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        return OpenMatrix4f.scale(new Vec3f(1.2f, 1.2f, 1.2f), mat, mat);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.skeleton;
    }
}

