/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.Hand;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.KatanaPassive;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.KnuckleCapability;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.capabilities.item.ShieldCapability;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.TridentCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class WeaponCapabilityPresets {
    public static final Function<Item, CapabilityItem.Builder> AXE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.AXE).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.TOOLS).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH, Animations.AXE_AIRSLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.ONE_HAND, Skills.GUILLOTINE_AXE).livingMotionModifier(CapabilityItem.Styles.ONE_HAND, LivingMotions.BLOCK, Animations.SWORD_GUARD);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).func_200891_e().func_200925_d();
            if (harvestLevel != 0) {
                ((CapabilityItem.Builder)builder).addStyleAttibutes(CapabilityItem.Styles.COMMON, (Pair<Attribute, AttributeModifier>)Pair.of((Object)EpicFightAttributes.ARMOR_NEGATION.get(), (Object)EpicFightAttributes.getArmorNegationModifier(10.0 * (double)harvestLevel)));
            }
            ((CapabilityItem.Builder)builder).addStyleAttibutes(CapabilityItem.Styles.COMMON, (Pair<Attribute, AttributeModifier>)Pair.of((Object)EpicFightAttributes.IMPACT.get(), (Object)EpicFightAttributes.getImpactModifier(0.7 + 0.3 * (double)harvestLevel)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> HOE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.HOE).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.TOOLS).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.TOOL_AUTO1, Animations.TOOL_AUTO2, Animations.TOOL_DASH, Animations.SWORD_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).func_200891_e().func_200925_d();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.IMPACT.get(), (Object)EpicFightAttributes.getImpactModifier(-0.4 + 0.1 * (double)harvestLevel)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> PICKAXE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.PICKAXE).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.TOOLS).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH, Animations.AXE_AIRSLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).func_200891_e().func_200925_d();
            if (harvestLevel != 0) {
                builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.ARMOR_NEGATION.get(), (Object)EpicFightAttributes.getArmorNegationModifier(6.0 * (double)harvestLevel)));
            }
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.IMPACT.get(), (Object)EpicFightAttributes.getImpactModifier(0.4 + 0.1 * (double)harvestLevel)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SHOVEL = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.SHOVEL).collider(ColliderPreset.TOOLS).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH, Animations.AXE_AIRSLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).func_200891_e().func_200925_d();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.IMPACT.get(), (Object)EpicFightAttributes.getImpactModifier(0.8 + 0.4 * (double)harvestLevel)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SWORD = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.SWORD).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(Hand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).collider(ColliderPreset.SWORD).hitSound(EpicFightSounds.BLADE_HIT).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.SWORD_AUTO1, Animations.SWORD_AUTO2, Animations.SWORD_AUTO3, Animations.SWORD_DASH, Animations.SWORD_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.SWORD_DUAL_AUTO1, Animations.SWORD_DUAL_AUTO2, Animations.SWORD_DUAL_AUTO3, Animations.SWORD_DUAL_DASH, Animations.SWORD_DUAL_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.ONE_HAND, Skills.SWEEPING_EDGE).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.DANCING_EDGE).livingMotionModifier(CapabilityItem.Styles.ONE_HAND, LivingMotions.BLOCK, Animations.SWORD_GUARD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.SWORD_DUAL_GUARD).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).func_184592_cb()).weaponCategory == CapabilityItem.WeaponCategories.SWORD);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).func_200891_e().func_200925_d();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.IMPACT.get(), (Object)EpicFightAttributes.getImpactModifier(0.5 + 0.2 * (double)harvestLevel)));
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)EpicFightAttributes.MAX_STRIKES.get(), (Object)EpicFightAttributes.getMaxStrikesModifier(1)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SPEAR = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(Hand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? CapabilityItem.Styles.ONE_HAND : CapabilityItem.Styles.TWO_HAND).collider(ColliderPreset.SPEAR).hitSound(EpicFightSounds.BLADE_HIT).canBePlacedOffhand(false).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.SPEAR_ONEHAND_AUTO, Animations.SPEAR_DASH, Animations.SPEAR_ONEHAND_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.SPEAR_TWOHAND_AUTO1, Animations.SPEAR_TWOHAND_AUTO2, Animations.SPEAR_DASH, Animations.SPEAR_TWOHAND_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SPEAR_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.ONE_HAND, Skills.HEARTPIERCER).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.SLAUGHTER_STANCE).livingMotionModifier(CapabilityItem.Styles.ONE_HAND, LivingMotions.RUN, Animations.BIPED_RUN_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.IDLE, Animations.BIPED_HOLD_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.WALK, Animations.BIPED_HOLD_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.CHASE, Animations.BIPED_HOLD_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.RUN, Animations.BIPED_RUN_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.SPEAR_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> GREATSWORD = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.GREATSWORD).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(ColliderPreset.GREATSWORD).swingSound(EpicFightSounds.WHOOSH_BIG).hitSound(EpicFightSounds.BLADE_HIT).canBePlacedOffhand(false).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.GREATSWORD_AUTO1, Animations.GREATSWORD_AUTO2, Animations.GREATSWORD_DASH, Animations.GREATSWORD_AIR_SLASH).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.GIANT_WHIRLWIND).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.IDLE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.WALK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.RUN, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.GREATSWORD_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> KATANA = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.KATANA).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill(SkillCategories.WEAPON_PASSIVE).getDataManager().hasData(KatanaPassive.SHEATH) && playerpatch.getSkill(SkillCategories.WEAPON_PASSIVE).getDataManager().getDataValue(KatanaPassive.SHEATH).booleanValue()) {
                return CapabilityItem.Styles.SHEATH;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).passiveSkill(Skills.KATANA_PASSIVE).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.KATANA).canBePlacedOffhand(false).newStyleCombo(CapabilityItem.Styles.SHEATH, Animations.KATANA_SHEATHING_AUTO, Animations.KATANA_SHEATHING_DASH, Animations.KATANA_SHEATH_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.KATANA_AUTO1, Animations.KATANA_AUTO2, Animations.KATANA_AUTO3, Animations.SWORD_DASH, Animations.KATANA_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.SHEATH, Skills.FATAL_DRAW).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.FATAL_DRAW).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.IDLE, Animations.BIPED_HOLD_KATANA).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.KNEEL, Animations.BIPED_HOLD_KATANA).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.WALK, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.CHASE, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.RUN, Animations.BIPED_RUN_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SNEAK, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SWIM, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.FLOAT, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.FALL, Animations.BIPED_WALK_UNSHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.IDLE, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.KNEEL, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.WALK, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.CHASE, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.RUN, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.SNEAK, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.SWIM, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.FLOAT, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.SHEATH, LivingMotions.FALL, Animations.BIPED_HOLD_KATANA_SHEATHING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.KATANA_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> TACHI = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.TACHI).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(ColliderPreset.KATANA).hitSound(EpicFightSounds.BLADE_HIT).canBePlacedOffhand(false).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.LONGSWORD_AUTO1, Animations.LONGSWORD_AUTO2, Animations.LONGSWORD_AUTO3, Animations.TACHI_DASH, Animations.LONGSWORD_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.LETHAL_SLICING).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.IDLE, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.KNEEL, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.WALK, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.CHASE, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.RUN, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SNEAK, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SWIM, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.FLOAT, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.FALL, Animations.BIPED_HOLD_TACHI).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.LONGSWORD_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> LONGSWORD = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.LONGSWORD).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill(SkillCategories.WEAPON_SPECIAL_ATTACK).getRemainDuration() > 0) {
                return CapabilityItem.Styles.LIECHTENAUER;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.LONGSWORD).canBePlacedOffhand(false).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.LONGSWORD_AUTO1, Animations.LONGSWORD_AUTO2, Animations.LONGSWORD_AUTO3, Animations.LONGSWORD_DASH, Animations.LONGSWORD_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.LIECHTENAUER, Animations.LONGSWORD_AUTO1, Animations.LONGSWORD_AUTO2, Animations.LONGSWORD_AUTO3, Animations.LONGSWORD_DASH, Animations.LONGSWORD_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.LIECHTENAUER).specialAttack(CapabilityItem.Styles.LIECHTENAUER, Skills.LIECHTENAUER).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.IDLE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.WALK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.RUN, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.TWO_HAND, LivingMotions.BLOCK, Animations.LONGSWORD_GUARD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.IDLE, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.WALK, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.RUN, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.SNEAK, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.KNEEL, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.JUMP, Animations.BIPED_HOLD_LONGSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier(CapabilityItem.Styles.LIECHTENAUER, LivingMotions.BLOCK, Animations.LONGSWORD_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> DAGGER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category(CapabilityItem.WeaponCategories.DAGGER).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(Hand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.DAGGER ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).hitSound(EpicFightSounds.BLADE_HIT).collider(ColliderPreset.DAGGER).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).func_184592_cb()).weaponCategory == CapabilityItem.WeaponCategories.DAGGER).newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.DAGGER_AUTO1, Animations.DAGGER_AUTO2, Animations.DAGGER_AUTO3, Animations.SWORD_DASH, Animations.DAGGER_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.TWO_HAND, Animations.DAGGER_DUAL_AUTO1, Animations.DAGGER_DUAL_AUTO2, Animations.DAGGER_DUAL_AUTO3, Animations.DAGGER_DUAL_AUTO4, Animations.DAGGER_DUAL_DASH, Animations.DAGGER_DUAL_AIR_SLASH).newStyleCombo(CapabilityItem.Styles.MOUNT, Animations.SWORD_MOUNT_ATTACK).specialAttack(CapabilityItem.Styles.ONE_HAND, Skills.EVISCERATE).specialAttack(CapabilityItem.Styles.TWO_HAND, Skills.BLADE_RUSH);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> FIST = item -> WeaponCapability.builder().newStyleCombo(CapabilityItem.Styles.ONE_HAND, Animations.FIST_AUTO1, Animations.FIST_AUTO2, Animations.FIST_AUTO3, Animations.FIST_DASH, Animations.FIST_AIR_SLASH).specialAttack(CapabilityItem.Styles.ONE_HAND, Skills.RELENTLESS_COMBO).category(CapabilityItem.WeaponCategories.FIST).constructor(KnuckleCapability::new);
    public static final Function<Item, CapabilityItem.Builder> BOW = item -> RangedWeaponCapability.builder().addAnimationsModifier(LivingMotions.IDLE, Animations.BIPED_IDLE).addAnimationsModifier(LivingMotions.WALK, Animations.BIPED_WALK).addAnimationsModifier(LivingMotions.AIM, Animations.BIPED_BOW_AIM).addAnimationsModifier(LivingMotions.SHOT, Animations.BIPED_BOW_SHOT);
    public static final Function<Item, CapabilityItem.Builder> CROSSBOW = item -> RangedWeaponCapability.builder().addAnimationsModifier(LivingMotions.IDLE, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.KNEEL, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.WALK, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.RUN, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.SNEAK, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.SWIM, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.FLOAT, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.FALL, Animations.BIPED_HOLD_CROSSBOW).addAnimationsModifier(LivingMotions.RELOAD, Animations.BIPED_CROSSBOW_RELOAD).addAnimationsModifier(LivingMotions.AIM, Animations.BIPED_CROSSBOW_AIM).addAnimationsModifier(LivingMotions.SHOT, Animations.BIPED_CROSSBOW_SHOT);
    public static final Function<Item, CapabilityItem.Builder> TRIDENT = item -> RangedWeaponCapability.builder().addAnimationsModifier(LivingMotions.IDLE, Animations.BIPED_IDLE).addAnimationsModifier(LivingMotions.WALK, Animations.BIPED_WALK).addAnimationsModifier(LivingMotions.AIM, Animations.BIPED_JAVELIN_AIM).addAnimationsModifier(LivingMotions.SHOT, Animations.BIPED_JAVELIN_THROW).constructor(TridentCapability::new).category(CapabilityItem.WeaponCategories.TRIDENT);
    public static final Function<Item, CapabilityItem.Builder> SHIELD = item -> CapabilityItem.builder().constructor(ShieldCapability::new).category(CapabilityItem.WeaponCategories.SHIELD);
    private static final Map<String, Function<Item, CapabilityItem.Builder>> PRESETS = Maps.newHashMap();

    public static void register() {
        HashMap typeEntry = Maps.newHashMap();
        typeEntry.put("axe", AXE);
        typeEntry.put("fist", FIST);
        typeEntry.put("hoe", HOE);
        typeEntry.put("pickaxe", PICKAXE);
        typeEntry.put("shovel", SHOVEL);
        typeEntry.put("sword", SWORD);
        typeEntry.put("spear", SPEAR);
        typeEntry.put("greatsword", GREATSWORD);
        typeEntry.put("katana", KATANA);
        typeEntry.put("tachi", TACHI);
        typeEntry.put("longsword", LONGSWORD);
        typeEntry.put("dagger", DAGGER);
        typeEntry.put("bow", BOW);
        typeEntry.put("crossbow", CROSSBOW);
        typeEntry.put("trident", TRIDENT);
        typeEntry.put("shield", SHIELD);
        WeaponCapabilityPresetRegistryEvent weaponCapabilityPresetRegistryEvent = new WeaponCapabilityPresetRegistryEvent(typeEntry);
        ModLoader.get().postEvent((Event)weaponCapabilityPresetRegistryEvent);
        weaponCapabilityPresetRegistryEvent.getTypeEntry().forEach(PRESETS::put);
    }

    public static Function<Item, CapabilityItem.Builder> get(String typeName) {
        return PRESETS.get(typeName);
    }
}

