/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.forgeevent.EntityPatchRegistryEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherGhostPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.CaveSpiderPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.CreeperPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.DrownedPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EvokerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.HoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.IronGolemPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinBrutePatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PiglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.PillagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.RavagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.SkeletonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.SpiderPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.StrayPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.VexPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.VindicatorPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitchPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.WitherSkeletonPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZoglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombiePatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombieVillagerPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.ZombifiedPiglinPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.EpicFightEntities;

public class ProviderEntity
implements ICapabilityProvider,
NonNullSupplier<EntityPatch<?>> {
    private static final Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CAPABILITIES = Maps.newHashMap();
    private static final Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CUSTOM_CAPABILITIES = Maps.newHashMap();
    private EntityPatch<?> capability;
    private LazyOptional<EntityPatch<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerEntityPatches() {
        HashMap registry = Maps.newHashMap();
        registry.put(EntityType.field_200729_aH, entityIn -> ServerPlayerPatch::new);
        registry.put(EntityType.field_200725_aD, entityIn -> ZombiePatch::new);
        registry.put(EntityType.field_200797_k, entityIn -> CreeperPatch::new);
        registry.put(EntityType.field_200803_q, entityIn -> EndermanPatch::new);
        registry.put(EntityType.field_200741_ag, entityIn -> SkeletonPatch::new);
        registry.put(EntityType.field_200722_aA, entityIn -> WitherSkeletonPatch::new);
        registry.put(EntityType.field_200750_ap, entityIn -> StrayPatch::new);
        registry.put(EntityType.field_233592_ba_, entityIn -> ZombifiedPiglinPatch::new);
        registry.put(EntityType.field_200727_aF, entityIn -> ZombieVillagerPatch::new);
        registry.put(EntityType.field_200763_C, entityIn -> ZombiePatch::new);
        registry.put(EntityType.field_200748_an, entityIn -> SpiderPatch::new);
        registry.put(EntityType.field_200794_h, entityIn -> CaveSpiderPatch::new);
        registry.put(EntityType.field_200757_aw, entityIn -> IronGolemPatch::new);
        registry.put(EntityType.field_200758_ax, entityIn -> VindicatorPatch::new);
        registry.put(EntityType.field_200806_t, entityIn -> EvokerPatch::new);
        registry.put(EntityType.field_200759_ay, entityIn -> WitchPatch::new);
        registry.put(EntityType.field_204724_o, entityIn -> DrownedPatch::new);
        registry.put(EntityType.field_220350_aJ, entityIn -> PillagerPatch::new);
        registry.put(EntityType.field_220352_aU, entityIn -> RavagerPatch::new);
        registry.put(EntityType.field_200755_au, entityIn -> VexPatch::new);
        registry.put(EntityType.field_233591_ai_, entityIn -> PiglinPatch::new);
        registry.put(EntityType.field_242287_aj, entityIn -> PiglinBrutePatch::new);
        registry.put(EntityType.field_233588_G_, entityIn -> HoglinPatch::new);
        registry.put(EntityType.field_233590_aW_, entityIn -> ZoglinPatch::new);
        registry.put(EntityType.field_200802_p, entityIn -> {
            if (entityIn instanceof EnderDragonEntity) {
                return EnderDragonPatch::new;
            }
            return () -> null;
        });
        registry.put(EntityType.field_200760_az, entityIn -> WitherPatch::new);
        registry.put(EpicFightEntities.WITHER_SKELETON_MINION.get(), entityIn -> WitherSkeletonPatch::new);
        registry.put(EpicFightEntities.WITHER_GHOST_CLONE.get(), entityIn -> WitherGhostPatch::new);
        EntityPatchRegistryEvent entitypatchRegistryEvent = new EntityPatchRegistryEvent(registry);
        ModLoader.get().postEvent((Event)entitypatchRegistryEvent);
        registry.forEach(CAPABILITIES::put);
    }

    public static void registerEntityPatchesClient() {
        CAPABILITIES.put(EntityType.field_200729_aH, entityIn -> {
            if (entityIn instanceof ClientPlayerEntity) {
                return LocalPlayerPatch::new;
            }
            if (entityIn instanceof RemoteClientPlayerEntity) {
                return AbstractClientPlayerPatch::new;
            }
            if (entityIn instanceof ServerPlayerEntity) {
                return ServerPlayerPatch::new;
            }
            return () -> null;
        });
    }

    public static void clear() {
        CUSTOM_CAPABILITIES.clear();
    }

    public static void putCustomEntityPatch(EntityType<?> entityType, Function<Entity, Supplier<EntityPatch<?>>> entitypatchProvider) {
        CUSTOM_CAPABILITIES.put(entityType, entitypatchProvider);
    }

    public static Function<Entity, Supplier<EntityPatch<?>>> get(String registryName) {
        ResourceLocation rl = new ResourceLocation(registryName);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(rl);
        return CAPABILITIES.get(entityType);
    }

    public ProviderEntity(Entity entity) {
        Function<Entity, Supplier<EntityPatch<?>>> provider = CUSTOM_CAPABILITIES.getOrDefault(entity.func_200600_R(), CAPABILITIES.get(entity.func_200600_R()));
        if (provider != null) {
            this.capability = provider.apply(entity).get();
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public EntityPatch<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_ENTITY ? this.optional.cast() : LazyOptional.empty();
    }
}

