/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.TagBasedSeparativeCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;

public class ProviderItem
implements ICapabilityProvider,
NonNullSupplier<CapabilityItem> {
    private static final Map<Class<? extends Item>, Function<Item, CapabilityItem.Builder>> CAPABILITY_BY_CLASS = Maps.newHashMap();
    private static final Map<Item, CapabilityItem> CAPABILITIES = Maps.newHashMap();
    private CapabilityItem capability;
    private LazyOptional<CapabilityItem> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerWeaponTypesByClass() {
        CAPABILITY_BY_CLASS.put(ArmorItem.class, item -> ArmorCapability.builder().item((Item)item));
        CAPABILITY_BY_CLASS.put(ShieldItem.class, WeaponCapabilityPresets.SHIELD);
        CAPABILITY_BY_CLASS.put(SwordItem.class, WeaponCapabilityPresets.SWORD);
        CAPABILITY_BY_CLASS.put(PickaxeItem.class, WeaponCapabilityPresets.PICKAXE);
        CAPABILITY_BY_CLASS.put(AxeItem.class, WeaponCapabilityPresets.AXE);
        CAPABILITY_BY_CLASS.put(ShovelItem.class, WeaponCapabilityPresets.SHOVEL);
        CAPABILITY_BY_CLASS.put(HoeItem.class, WeaponCapabilityPresets.HOE);
        CAPABILITY_BY_CLASS.put(BowItem.class, WeaponCapabilityPresets.BOW);
        CAPABILITY_BY_CLASS.put(CrossbowItem.class, WeaponCapabilityPresets.CROSSBOW);
    }

    public static void put(Item item, CapabilityItem cap) {
        CAPABILITIES.put(item, cap);
    }

    public static boolean has(Item item) {
        return CAPABILITIES.containsKey(item);
    }

    public static void clear() {
        CAPABILITIES.clear();
    }

    public static void addDefaultItems() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (CAPABILITIES.containsKey(item)) continue;
            CapabilityItem capability = null;
            for (Class<?> clazz = item.getClass(); clazz != null && capability == null; clazz = clazz.getSuperclass()) {
                if (!CAPABILITY_BY_CLASS.containsKey(clazz)) continue;
                capability = CAPABILITY_BY_CLASS.get(clazz).apply(item).build();
            }
            if (capability == null) continue;
            CAPABILITIES.put(item, capability);
        }
    }

    public ProviderItem(ItemStack itemstack) {
        this.capability = CAPABILITIES.get(itemstack.func_77973_b());
        if (this.capability instanceof TagBasedSeparativeCapability) {
            this.capability = this.capability.getResult(itemstack);
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_ITEM ? this.optional.cast() : LazyOptional.empty();
    }

    public CapabilityItem get() {
        return this.capability;
    }
}

