/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.projectile.ArrowPatch;
import yesman.epicfight.world.capabilities.projectile.DragonFireballPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.capabilities.projectile.WitherSkullPatch;

public class ProviderProjectile
implements ICapabilityProvider,
NonNullSupplier<ProjectilePatch<?>> {
    private static final Map<EntityType<?>, Supplier<ProjectilePatch<?>>> CAPABILITY_BY_TYPE = new HashMap();
    private static final Map<Class<? extends ProjectileEntity>, Supplier<ProjectilePatch<?>>> CAPABILITY_BY_CLASS = new HashMap();
    private ProjectilePatch<?> capability;
    private LazyOptional<ProjectilePatch<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void registerPatches() {
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.field_200790_d, type -> ArrowPatch::new);
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.field_200723_aB, type -> WitherSkullPatch::new);
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.field_200799_m, type -> DragonFireballPatch::new);
        CAPABILITY_BY_CLASS.put(AbstractArrowEntity.class, ArrowPatch::new);
    }

    public ProviderProjectile(ProjectileEntity projectile) {
        if (CAPABILITY_BY_TYPE.containsKey(projectile.func_200600_R())) {
            this.capability = CAPABILITY_BY_TYPE.get(projectile.func_200600_R()).get();
        } else {
            Supplier<ProjectilePatch<?>> capSupplier = this.makeCustomCapability(projectile);
            CAPABILITY_BY_TYPE.put(projectile.func_200600_R(), capSupplier);
            this.capability = capSupplier.get();
        }
    }

    private Supplier<ProjectilePatch<?>> makeCustomCapability(ProjectileEntity projectileEntity) {
        Supplier<ProjectilePatch<?>> cap = () -> null;
        for (Class<?> clazz = projectileEntity.getClass(); clazz != null && cap.get() == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, () -> null);
        }
        return cap;
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public ProjectilePatch<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == EpicFightCapabilities.CAPABILITY_PROJECTILE ? this.optional.cast() : LazyOptional.empty();
    }
}

