/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.skill;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import yesman.epicfight.gameasset.Skills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CapabilitySkill {
    public static final CapabilitySkill EMPTY = new CapabilitySkill(null);
    public final SkillContainer[] skillContainers;
    private final HashMultimap<SkillCategory, Skill> learnedSkills = HashMultimap.create();

    public CapabilitySkill(PlayerPatch<?> playerpatch) {
        Collection<SkillCategory> categories = SkillCategory.ENUM_MANAGER.universalValues();
        this.skillContainers = new SkillContainer[categories.size()];
        for (SkillCategory slot : categories) {
            this.skillContainers[slot.universalOrdinal()] = new SkillContainer(playerpatch, slot.universalOrdinal());
        }
    }

    public void clear() {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            if (SkillCategory.ENUM_MANAGER.get(i).learnable()) {
                container.setSkill(null);
            }
            ++i;
        }
        this.learnedSkills.clear();
    }

    public void addLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (!this.learnedSkills.containsKey((Object)category) || !this.learnedSkills.get((Object)category).contains(skill)) {
            this.learnedSkills.put((Object)category, (Object)skill);
        }
    }

    public boolean removeLearnedSkill(Skill skill) {
        SkillCategory category = skill.getCategory();
        if (this.learnedSkills.containsKey((Object)category) && this.learnedSkills.remove((Object)category, (Object)skill)) {
            if (this.learnedSkills.get((Object)category).size() == 0) {
                this.learnedSkills.removeAll((Object)category);
            }
            return true;
        }
        return false;
    }

    public Collection<Skill> getLearnedSkills(SkillCategory skillCategory) {
        return this.learnedSkills.get((Object)skillCategory);
    }

    public boolean hasCategory(SkillCategory skillCategory) {
        return this.learnedSkills.containsKey((Object)skillCategory);
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (SkillContainer container : this.skillContainers) {
            if (container.getSkill() == null || !container.getSkill().getCategory().shouldSaved()) continue;
            nbt.func_74778_a(String.valueOf(container.getSkill().getCategory().universalOrdinal()), container.getSkill().toString());
        }
        for (Map.Entry entry : this.learnedSkills.asMap().entrySet()) {
            CompoundNBT learnedNBT = new CompoundNBT();
            int i = 0;
            for (Skill skill : (Collection)entry.getValue()) {
                learnedNBT.func_74778_a(String.valueOf(i++), skill.toString());
            }
            nbt.func_218657_a(String.valueOf("learned" + ((SkillCategory)entry.getKey()).universalOrdinal()), (INBT)learnedNBT);
        }
        return nbt;
    }

    public void fromNBT(CompoundNBT nbt) {
        int i = 0;
        for (SkillContainer container : this.skillContainers) {
            if (nbt.func_74764_b(String.valueOf(i))) {
                Skill skill = Skills.getSkill(nbt.func_74779_i(String.valueOf(i)));
                container.setSkill(skill);
                this.addLearnedSkill(skill);
            }
            ++i;
        }
        for (SkillCategory category : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!nbt.func_74764_b("learned" + String.valueOf(category.universalOrdinal()))) continue;
            CompoundNBT learnedNBT = nbt.func_74775_l("learned" + String.valueOf(category.universalOrdinal()));
            for (String key : learnedNBT.func_150296_c()) {
                this.addLearnedSkill(Skills.getSkill(learnedNBT.func_74779_i(key)));
            }
        }
    }
}

