/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ShootableItem;
import net.minecraft.world.server.ServerWorld;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AnimatedCombatBehavior<T extends MobPatch<?>>
extends Task<MobEntity> {
    protected final T mobpatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AnimatedCombatBehavior(T mobpatch, CombatBehaviors<T> combatBehaviors) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    protected boolean checkExtraStartConditions(ServerWorld levelIn, MobEntity entityIn) {
        return !this.isHoldingRangeWeapon(entityIn) && this.isValidTarget(((MobPatch)this.mobpatch).getTarget());
    }

    protected boolean canStillUse(ServerWorld levelIn, MobEntity entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(levelIn, entityIn) && BrainUtil.func_233876_c_((LivingEntity)entityIn, (LivingEntity)((MobPatch)this.mobpatch).getTarget()) && !((LivingEntityPatch)this.mobpatch).getEntityState().hurt();
    }

    protected void tick(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        CombatBehaviors.Behavior<T> result;
        EntityState state = ((LivingEntityPatch)this.mobpatch).getEntityState();
        this.combatBehaviors.tick();
        if (this.combatBehaviors.hasActivatedMove()) {
            CombatBehaviors.Behavior<T> result2;
            if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                result2.execute(this.mobpatch);
            }
        } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
            result.execute(this.mobpatch);
        }
    }

    private boolean isHoldingRangeWeapon(MobEntity mob) {
        return mob.func_233634_a_(stack -> {
            Item item = stack.getItem();
            return item instanceof ShootableItem && mob.func_230280_a_((ShootableItem)item);
        });
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.func_70089_S() && (!(attackTarget instanceof PlayerEntity) || !((PlayerEntity)attackTarget).func_175149_v() && !((PlayerEntity)attackTarget).func_184812_l_());
    }
}

