/*
 * Decompiled with CFR 0.152.
 */
package tfar.lockon;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class LockOnHandler {
    public static KeyBinding LOCK_ON;
    public static KeyBinding TAB;
    public static List<LivingEntity> list;
    private static final Minecraft mc;
    public static boolean lockedOn;
    private static Entity targetted;
    private static final Predicate<LivingEntity> ENTITY_PREDICATE;
    private static final EntityPredicate ENEMY_CONDITION;
    private static int cycle;

    public static void client(FMLClientSetupEvent e) {
        LOCK_ON = new KeyBinding("key.lockon.lock_on", 79, "key.categories.lockon");
        TAB = new KeyBinding("key.lockon.tab", 258, "key.categories.lockon");
        ClientRegistry.registerKeyBinding((KeyBinding)LOCK_ON);
        ClientRegistry.registerKeyBinding((KeyBinding)TAB);
        MinecraftForge.EVENT_BUS.addListener(LockOnHandler::handleKeyPress);
    }

    private static void handleKeyPress(TickEvent.RenderTickEvent e) {
        ClientPlayerEntity player = LockOnHandler.mc.field_71439_g;
        if (e.phase == TickEvent.Phase.START && LockOnHandler.mc.field_71439_g != null && !mc.func_147113_T()) {
            LockOnHandler.tickLockedOn();
            while (LOCK_ON.func_151468_f()) {
                if (lockedOn) {
                    LockOnHandler.leaveLockOn();
                    continue;
                }
                LockOnHandler.attemptEnterLockOn((PlayerEntity)player);
            }
            while (TAB.func_151468_f()) {
                LockOnHandler.tabToNextEnemy((PlayerEntity)player);
            }
            if (targetted != null) {
                double newDelta;
                float adjustedPrevYaw;
                Vector3d targetPos = targetted.func_213303_ch();
                Vector3d directionVec = targetPos.func_178788_d(LockOnHandler.mc.field_71439_g.func_213303_ch()).func_72432_b();
                double angle = Math.atan2(-directionVec.field_72450_a, directionVec.field_72449_c) * 180.0 / Math.PI;
                if (Math.abs(angle - (double)(adjustedPrevYaw = LockOnHandler.mc.field_71439_g.field_70126_B)) > 180.0) {
                    if ((double)adjustedPrevYaw > angle) {
                        angle += 360.0;
                    } else if ((double)adjustedPrevYaw < angle) {
                        angle -= 360.0;
                    }
                }
                if ((newDelta = (double)MathHelper.func_219799_g((float)e.renderTickTime, (float)adjustedPrevYaw, (float)((float)angle))) > 180.0) {
                    newDelta -= 360.0;
                }
                if (newDelta < -180.0) {
                    newDelta += 360.0;
                }
                LockOnHandler.mc.field_71439_g.field_70177_z = (float)newDelta;
            }
        }
    }

    private static void attemptEnterLockOn(PlayerEntity player) {
        LockOnHandler.tabToNextEnemy(player);
        if (targetted != null) {
            lockedOn = true;
        }
    }

    private static void tickLockedOn() {
        list.removeIf(livingEntity -> LockOnHandler.mc.field_71439_g == null || !livingEntity.func_70089_S());
        if (targetted != null && !targetted.func_70089_S()) {
            targetted = null;
            lockedOn = false;
        }
    }

    public static Entity findNearby(PlayerEntity player) {
        List entities = player.field_70170_p.func_217374_a(LivingEntity.class, ENEMY_CONDITION, (LivingEntity)player, player.func_174813_aQ().func_72314_b(10.0, 2.0, 10.0));
        if (lockedOn) {
            ++cycle;
            for (LivingEntity entity : entities) {
                if (list.contains(entity)) continue;
                list.add(entity);
                return entity;
            }
            if (cycle >= list.size()) {
                cycle = 0;
            }
            return (Entity)list.get(cycle);
        }
        if (!entities.isEmpty()) {
            LivingEntity first = (LivingEntity)entities.get(0);
            list.add(first);
            return (Entity)entities.get(0);
        }
        return null;
    }

    private static void tabToNextEnemy(PlayerEntity player) {
        targetted = LockOnHandler.findNearby(player);
    }

    private static void leaveLockOn() {
        targetted = null;
        lockedOn = false;
        list.clear();
    }

    static {
        list = new ArrayList<LivingEntity>();
        mc = Minecraft.func_71410_x();
        ENTITY_PREDICATE = entity -> entity.func_70089_S() && entity.func_190631_cK();
        ENEMY_CONDITION = new EntityPredicate().func_221013_a(20.0).func_221012_a(ENTITY_PREDICATE);
        cycle = -1;
    }
}

