/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncConfigPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.SkillBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class DSSCombatEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    private static void addDrop(Class<? extends EntityLivingBase> mobClass, SkillBase skill) {
        ItemStack stack = new ItemStack(DynamicSwordSkills.skillOrb, 1, (int)skill.getId());
        dropsList.put(mobClass, stack);
    }

    public static void initializeDrops() {
        DSSCombatEvents.addDrop(EntityZombie.class, SkillBase.swordBasic);
        DSSCombatEvents.addDrop(EntitySkeleton.class, SkillBase.swordBasic);
        DSSCombatEvents.addDrop(EntityEnderman.class, SkillBase.dodge);
        DSSCombatEvents.addDrop(EntitySilverfish.class, SkillBase.backSlice);
        DSSCombatEvents.addDrop(EntitySlime.class, SkillBase.dash);
        DSSCombatEvents.addDrop(EntityHorse.class, SkillBase.dash);
        DSSCombatEvents.addDrop(EntityPigZombie.class, SkillBase.parry);
        DSSCombatEvents.addDrop(EntityOcelot.class, SkillBase.mortalDraw);
        DSSCombatEvents.addDrop(EntitySpider.class, SkillBase.endingBlow);
        DSSCombatEvents.addDrop(EntityCaveSpider.class, SkillBase.leapingBlow);
        DSSCombatEvents.addDrop(EntityMagmaCube.class, SkillBase.leapingBlow);
        DSSCombatEvents.addDrop(EntityBlaze.class, SkillBase.spinAttack);
        DSSCombatEvents.addDrop(EntityBat.class, SkillBase.risingCut);
        DSSCombatEvents.addDrop(EntityCreeper.class, SkillBase.armorBreak);
        DSSCombatEvents.addDrop(EntityIronGolem.class, SkillBase.swordBreak);
        DSSCombatEvents.addDrop(EntityGhast.class, SkillBase.superSpinAttack);
        DSSCombatEvents.addDrop(EntityWitch.class, SkillBase.swordBeam);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob) {
        if (dropsList.get(mob.getClass()) != null && mob.func_130014_f_().field_73012_v.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        boolean flag = mob instanceof EntityPlayer;
        int id = mob.func_130014_f_().field_73012_v.nextInt(SkillBase.getNumSkills());
        if (SkillBase.doesSkillExist(id) && (!flag || Config.arePlayerDropsEnabled())) {
            float chance = (flag ? Config.getPlayerDropFactor() : 1.0f) * Config.getRandomMobDropChance();
            if (dropsList.get(mob.getClass()) != null || mob.func_130014_f_().field_73012_v.nextFloat() < chance) {
                orb = new ItemStack(DynamicSwordSkills.skillOrb, 1, id);
            }
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        float baseChance;
        EntityLivingBase mob;
        ItemStack orb;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && (orb = DSSCombatEvents.getOrbDrop(mob = event.getEntityLiving())) != null && (Config.areOrbDropsEnabled() || Config.arePlayerDropsEnabled() && event.getEntity() instanceof EntityPlayer) && (baseChance = Config.getDropChance(orb.func_77952_i())) > 0.0f && mob.func_130014_f_().field_73012_v.nextFloat() < baseChance + 0.005f * (float)event.getLootingLevel()) {
            event.getDrops().add(new EntityItem(mob.func_130014_f_(), mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, orb.func_77946_l()));
            mob.func_130014_f_().func_184148_a(null, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, ModSounds.SPECIAL_DROP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void setPlayerAttackTime(EntityPlayer player) {
        DSSPlayerInfo.get(player).setAttackTime(Config.getBaseSwingSpeed());
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        if (!event.isCanceled() && event.getEntity() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.getEntity()).onBeingAttacked(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent event) {
        ICombo combo;
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            ICombo combo2 = skills.getComboSkill();
            if (combo2 != null && combo2.getCombo() != null && !combo2.getCombo().isFinished()) {
                event.setAmount(event.getAmount() + (float)combo2.getCombo().getNumHits());
            }
            if (skills.isSkillActive(SkillBase.armorBreak)) {
                ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).onImpact(player, event);
                return;
            }
            if (skills.isSkillActive(SkillBase.mortalDraw)) {
                ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).onImpact(player, event);
            }
        }
        if (event.getAmount() > 0.0f && event.getEntity() instanceof EntityPlayer && (combo = DSSPlayerInfo.get(player = (EntityPlayer)event.getEntity()).getComboSkill()) != null && event.getAmount() > 0.0f) {
            combo.onPlayerHurt(player, event);
        }
        if (event.getAmount() > 0.0f && event.getSource().func_76346_g() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.getSource().func_76346_g()).onPostImpact(event);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.getEntity()).onUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        DSSPlayerInfo.get(event.player).onPlayerLoggedIn();
        if (event.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncConfigPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.getEntity()).onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        DSSPlayerInfo.get(event.getEntityPlayer()).copy(DSSPlayerInfo.get(event.getOriginal()));
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            if (skills.isSkillActive(SkillBase.leapingBlow)) {
                ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.getDistance());
            }
            if (skills.reduceFallAmount > 0.0f) {
                event.setDistance(event.getDistance() - skills.reduceFallAmount);
                skills.reduceFallAmount = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        DSSPlayerInfo skills = DSSPlayerInfo.get(event.getEntityPlayer());
        if (skills != null && skills.isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(event.getEntityPlayer(), event.getDistance());
        }
    }
}

