/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import dynamicswordskills.CommonProxy;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.api.ItemRandomSkill;
import dynamicswordskills.api.ItemSkillProvider;
import dynamicswordskills.command.DSSCommands;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.entity.EntitySwordBeam;
import dynamicswordskills.entity.IPlayerInfo;
import dynamicswordskills.item.ItemSkillOrb;
import dynamicswordskills.loot.LootHandler;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import swordskillsapi.api.item.WeaponRegistry;

@Mod(modid="dynamicswordskills", name="Dynamic Sword Skills", version="1.12.2-6.0.1", updateJSON="https://raw.githubusercontent.com/coolAlias/DynamicSwordSkills/master/src/main/resources/versionlist.json", acceptedMinecraftVersions="[1.12.2]")
public class DynamicSwordSkills {
    @Mod.Instance(value="dynamicswordskills")
    public static DynamicSwordSkills instance;
    @SidedProxy(clientSide="dynamicswordskills.ClientProxy", serverSide="dynamicswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static CreativeTabs tabSkills;
    public static Item skillOrb;
    public static List<Item> skillItems;
    public static Item skillWood;
    public static Item skillStone;
    public static Item skillIron;
    public static Item skillDiamond;
    public static Item skillGold;
    private int entityId = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"zeldaswordskills")) {
            throw new RuntimeException("Dynamic Sword Skills may not be loaded at the same time as Zelda Sword Skills! Please remove one or the other.");
        }
        Config.init(event);
        tabSkills = new CreativeTabs("dss.skills"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(skillOrb);
            }
        };
        skillOrb = ((Item)new ItemSkillOrb().setRegistryName("dynamicswordskills", "skillorb")).func_77655_b("dss.skillorb");
        if (Config.areCreativeSwordsEnabled()) {
            skillItems = new ArrayList<Item>(SkillBase.getNumSkills());
            Item item = null;
            for (SkillBase skill : SkillBase.getSkills()) {
                if (!(skill instanceof SkillActive)) continue;
                int level = skill.getMaxLevel() == 5 ? Config.getSkillSwordLevel() : Config.getSkillSwordLevel() * 2;
                item = new ItemSkillProvider(Item.ToolMaterial.IRON, "iron_sword", skill, (byte)level).func_77637_a(tabSkills);
                skillItems.add(item);
            }
        }
        if (Config.areRandomSwordsEnabled()) {
            skillWood = new ItemRandomSkill(Item.ToolMaterial.WOOD, "wooden_sword");
            skillStone = new ItemRandomSkill(Item.ToolMaterial.STONE, "stone_sword");
            skillIron = new ItemRandomSkill(Item.ToolMaterial.IRON, "iron_sword");
            skillGold = new ItemRandomSkill(Item.ToolMaterial.GOLD, "golden_sword");
            skillDiamond = new ItemRandomSkill(Item.ToolMaterial.DIAMOND, "diamond_sword");
        }
        proxy.preInit();
        PacketDispatcher.initialize();
        this.registerCapabilities();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new DSSCombatEvents());
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        DSSCombatEvents.initializeDrops();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        FMLInterModComms.sendRuntimeMessage((Object)"dynamicswordskills", (String)"VersionChecker", (String)"addVersionCheck", (String)"https://raw.githubusercontent.com/coolAlias/DynamicSwordSkills/master/src/main/resources/versionlist.json");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        DSSCommands.registerCommands(event);
    }

    @Mod.EventHandler
    public void processMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            WeaponRegistry.INSTANCE.processMessage(msg);
        }
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityEntry[] entities = new EntityEntry[]{this.createEntityEntryBuilder("leapingblow", EntityLeapingBlow.class, 64, 10, true).build(), this.createEntityEntryBuilder("swordbeam", EntitySwordBeam.class, 64, 10, true).build()};
        event.getRegistry().registerAll((IForgeRegistryEntry[])entities);
    }

    private <E extends Entity> EntityEntryBuilder<E> createEntityEntryBuilder(String name, Class<? extends E> clazz, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        ResourceLocation location = new ResourceLocation("dynamicswordskills", name);
        return builder.id(location, this.entityId++).name(location.toString()).entity(clazz).tracker(trackingRange, updateFrequency, sendVelocityUpdates);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)skillOrb);
        if (Config.areCreativeSwordsEnabled()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])skillItems.toArray(new Item[skillItems.size()]));
        }
        if (Config.areRandomSwordsEnabled()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{skillWood, skillStone, skillIron, skillGold, skillDiamond});
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels(event);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        SoundEvent[] sounds = new SoundEvent[]{this.createSound(new ResourceLocation("dynamicswordskills", "armor_break")), this.createSound(new ResourceLocation("dynamicswordskills", "hurt_flesh")), this.createSound(new ResourceLocation("dynamicswordskills", "leaping_blow")), this.createSound(new ResourceLocation("dynamicswordskills", "level_up")), this.createSound(new ResourceLocation("dynamicswordskills", "mortal_draw")), this.createSound(new ResourceLocation("dynamicswordskills", "slam")), this.createSound(new ResourceLocation("dynamicswordskills", "special_drop")), this.createSound(new ResourceLocation("dynamicswordskills", "spin_attack")), this.createSound(new ResourceLocation("dynamicswordskills", "sword_cut")), this.createSound(new ResourceLocation("dynamicswordskills", "sword_miss")), this.createSound(new ResourceLocation("dynamicswordskills", "sword_strike")), this.createSound(new ResourceLocation("dynamicswordskills", "whoosh"))};
        event.getRegistry().registerAll((IForgeRegistryEntry[])sounds);
    }

    private SoundEvent createSound(ResourceLocation location) {
        return (SoundEvent)new SoundEvent(location).setRegistryName(location);
    }

    private void registerCapabilities() {
        IPlayerInfo.CapabilityPlayerInfo.register();
    }

    static {
        logger = LogManager.getLogger((String)"dynamicswordskills");
    }
}

