/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.item.IModItem;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRandomSkill
extends ItemSword
implements IModItem,
ISkillProvider {
    private final int quality;
    private final String texture;

    public ItemRandomSkill(Item.ToolMaterial material, String textureName) {
        super(material);
        this.texture = textureName;
        this.quality = material.func_77996_d() + (material == Item.ToolMaterial.GOLD ? 3 : 0);
        this.func_77637_a(null);
        this.setRegistryName("dynamicswordskills", "skillsword_" + material.name());
        this.func_77655_b("dss.skill" + material.name());
    }

    public boolean isSword(ItemStack stack) {
        return true;
    }

    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        return stack.func_77942_o() ? SkillBase.getSkillFromItem(stack, this) : null;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tag = stack.func_77978_p();
        SkillBase skill = null;
        if (tag.func_74764_b("ItemSkillName")) {
            skill = SkillBase.getSkillByName(tag.func_74779_i("ItemSkillName"));
        }
        if (tag.func_74764_b("ItemSkillId")) {
            if (skill == null) {
                skill = SkillBase.getSkill(tag.func_74762_e("ItemSkillId"));
                if (skill != null) {
                    tag.func_74778_a("ItemSkillName", skill.getUnlocalizedName());
                }
            } else if (tag.func_74762_e("ItemSkillId") != skill.getId()) {
                tag.func_74768_a("ItemSkillId", (int)skill.getId());
            }
        }
        return skill == null ? -1 : (int)skill.getId();
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("ItemSkillLevel") ? stack.func_77978_p().func_74771_c("ItemSkillLevel") : (byte)0;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("grantsBasicSword");
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return new TextComponentTranslation("item.dss.skillitem.name", new Object[]{skill == null ? "" : skill.getDisplayName()}).func_150260_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null && world != null) {
            list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.skill", new Object[]{TextFormatting.GOLD + skill.getDisplayName()}).func_150260_c());
            list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.level", new Object[]{skill.getLevel(), skill.getMaxLevel()}).func_150260_c());
            if (this.grantsBasicSwordSkill(stack)) {
                String name = TextFormatting.DARK_GREEN + SkillBase.swordBasic.getDisplayName() + TextFormatting.RESET;
                list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.provider", new Object[]{name}).func_150260_c());
            }
            list.addAll(skill.getDescription((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
    }

    @Override
    public String[] getVariants() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerResources() {
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.texture, "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ModelLoader.getInventoryVariant((String)ItemRandomSkill.this.texture);
            }
        });
    }

    public void generateSkillTag(ItemStack stack, SkillBase skill, Random rand) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("ItemSkillName", skill.getUnlocalizedName());
        int level = 1 + rand.nextInt(Math.min(this.quality + 2, skill.getMaxLevel()));
        tag.func_74774_a("ItemSkillLevel", (byte)level);
        boolean flag = skill.getId() != SkillBase.swordBasic.getId() && rand.nextInt(16) > 9 - this.quality;
        tag.func_74757_a("grantsBasicSword", flag);
    }
}

