/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.collect.Multimap;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.item.IModItem;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkillProvider
extends Item
implements IModItem,
ISkillProvider {
    private final Item.ToolMaterial material;
    private final String texture;
    private float weaponDamage;
    private final String skillName;
    private final byte level;
    private SkillBase skill;
    private final boolean grantsBasicSkill;

    public ItemSkillProvider(Item.ToolMaterial material, String texture, SkillBase skill, byte level) {
        this(material, texture, skill, level, true);
    }

    public ItemSkillProvider(Item.ToolMaterial material, String texture, SkillBase skill, byte level, boolean grantsBasicSkill) {
        this.material = material;
        this.texture = texture;
        this.weaponDamage = 4.0f + this.material.func_78000_c();
        this.skillName = skill.getUnlocalizedName();
        this.level = level;
        this.grantsBasicSkill = grantsBasicSkill;
        this.func_77656_e(this.material.func_77997_a());
        this.func_77625_d(1);
        this.setRegistryName("dynamicswordskills", "skillitem_" + skill.getUnlocalizedName());
        this.func_77655_b("dss.skillitem" + skill.getId());
    }

    public boolean isSword(ItemStack stack) {
        return false;
    }

    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        if (this.skill == null) {
            this.skill = SkillBase.getSkillFromItem(stack, this);
        }
        return this.skill;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        SkillBase skill = SkillBase.getSkillByName(this.skillName);
        return skill == null ? -1 : (int)skill.getId();
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return this.level;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return this.grantsBasicSkill;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack stack) {
        return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.material.getRepairItemStack()) || super.func_82789_a(toRepair, stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(2, entity);
        }
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return new TextComponentTranslation("item.dss.skillitem.name", new Object[]{skill == null ? "" : skill.getDisplayName()}).func_150260_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null && world != null) {
            list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.skill", new Object[]{TextFormatting.GOLD + skill.getDisplayName()}).func_150260_c());
            list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.level", new Object[]{skill.getLevel(), skill.getMaxLevel()}).func_150260_c());
            if (this.grantsBasicSwordSkill(stack)) {
                String name = TextFormatting.DARK_GREEN + SkillBase.swordBasic.getDisplayName() + TextFormatting.RESET;
                list.add(new TextComponentTranslation("tooltip.dss.skillprovider.desc.provider", new Object[]{name}).func_150260_c());
            }
            list.addAll(skill.getDescription((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
    }

    @Override
    public String[] getVariants() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerResources() {
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.texture, "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ModelLoader.getInventoryVariant((String)ItemSkillProvider.this.texture);
            }
        });
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }
}

