/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.server.OpenGuiPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class DSSKeyHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final byte KEY_SKILL_ACTIVATE = 0;
    public static final byte KEY_NEXT_TARGET = 1;
    public static final byte KEY_ATTACK = 2;
    public static final byte KEY_LEFT = 3;
    public static final byte KEY_RIGHT = 4;
    public static final byte KEY_DOWN = 5;
    public static final byte KEY_BLOCK = 6;
    public static final byte KEY_TOGGLE_AUTOTARGET = 7;
    public static final byte KEY_SKILLS_GUI = 8;
    public static final byte KEY_TOGGLE_HUD = 9;
    public static final String[] desc = new String[]{"activate", "next", "attack", "left", "right", "down", "block", "toggleat", "skills_gui", "togglehud"};
    private static final int[] keyValues = new int[]{45, 15, 200, 203, 205, 208, 157, 52, 25, 47};
    public static final KeyBinding[] keys = new KeyBinding[desc.length];

    public DSSKeyHandler() {
        for (int i = 0; i < desc.length; ++i) {
            DSSKeyHandler.keys[i] = new KeyBinding("key.dss." + desc[i] + ".desc", keyValues[i], "key.dss.label");
            ClientRegistry.registerKeyBinding((KeyBinding)keys[i]);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            DSSKeyHandler.onKeyPressed(this.mc, Keyboard.getEventKey());
        } else if (Keyboard.getEventKey() == keys[6].func_151463_i()) {
            KeyBinding.func_74510_a((int)this.mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
        }
    }

    public static void onKeyPressed(Minecraft mc, int kb) {
        if (mc.field_71415_G && mc.field_71439_g != null) {
            DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)mc.field_71439_g);
            if (kb == keys[0].func_151463_i()) {
                if (skills.hasSkill(SkillBase.swordBasic)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(SkillBase.swordBasic));
                }
            } else if (kb == keys[7].func_151463_i()) {
                if (mc.field_71439_g.func_70093_af()) {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.field_71439_g, "key.dss.toggletp", new TextComponentTranslation(Config.toggleTargetPlayers() ? "key.dss.enable" : "key.dss.disable", new Object[0]).func_150260_c());
                } else {
                    PlayerUtils.sendTranslatedChat((EntityPlayer)mc.field_71439_g, "key.dss.toggleat", new TextComponentTranslation(Config.toggleAutoTarget() ? "key.dss.enable" : "key.dss.disable", new Object[0]).func_150260_c());
                }
            } else if (kb == keys[8].func_151463_i()) {
                PacketDispatcher.sendToServer(new OpenGuiPacket(0));
            } else if (kb == keys[9].func_151463_i()) {
                Config.isComboHudEnabled = !Config.isComboHudEnabled;
                PlayerUtils.sendTranslatedChat((EntityPlayer)mc.field_71439_g, "key.dss.togglehud", new TextComponentTranslation(Config.isComboHudEnabled ? "key.dss.enable" : "key.dss.disable", new Object[0]).func_150260_c());
            } else {
                DSSKeyHandler.handleTargetingKeys(mc, kb, skills);
            }
        }
    }

    private static void handleTargetingKeys(Minecraft mc, int kb, DSSPlayerInfo skills) {
        KeyBinding key;
        ILockOnTarget skill = skills.getTargetingSkill();
        boolean canInteract = skills.canInteract();
        if (skill == null || !skill.isLockedOn()) {
            return;
        }
        if (kb == keys[1].func_151463_i()) {
            skill.getNextTarget((EntityPlayer)mc.field_71439_g);
        } else if (kb == keys[2].func_151463_i() || kb == mc.field_71474_y.field_74312_F.func_151463_i()) {
            KeyBinding key2 = kb == keys[2].func_151463_i() ? keys[2] : mc.field_71474_y.field_74312_F;
            boolean canAttack = skills.canAttack();
            if (canInteract && canAttack) {
                KeyBinding.func_74510_a((int)key2.func_151463_i(), (boolean)true);
            } else if (canAttack) {
                if (skills.isSkillActive(SkillBase.spinAttack)) {
                    skills.getActiveSkill(SkillBase.spinAttack).keyPressed(mc, key2, (EntityPlayer)mc.field_71439_g);
                    return;
                }
                if (skills.isSkillActive(SkillBase.backSlice)) {
                    skills.getActiveSkill(SkillBase.backSlice).keyPressed(mc, key2, (EntityPlayer)mc.field_71439_g);
                    return;
                }
            }
            if (key2.func_151470_d()) {
                if (!skills.onKeyPressed(mc, key2)) {
                    DSSClientEvents.performComboAttack(mc, skill);
                }
                if (skills.hasSkill(SkillBase.armorBreak)) {
                    skills.getActiveSkill(SkillBase.armorBreak).keyPressed(mc, key2, (EntityPlayer)mc.field_71439_g);
                }
            }
        } else if (canInteract && (key = DSSKeyHandler.getKeyBindFromCode(mc, kb)) != null) {
            KeyBinding.func_74510_a((int)kb, (boolean)true);
            if (kb == keys[6].func_151463_i()) {
                KeyBinding.func_74510_a((int)mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)true);
            }
            skills.onKeyPressed(mc, key);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyBinding getKeyBindFromCode(Minecraft mc, int keyCode) {
        for (KeyBinding k : keys) {
            if (k.func_151463_i() != keyCode) continue;
            return k;
        }
        if (keyCode == mc.field_71474_y.field_74351_w.func_151463_i()) {
            return mc.field_71474_y.field_74351_w;
        }
        if (keyCode == mc.field_71474_y.field_74314_A.func_151463_i()) {
            return mc.field_71474_y.field_74314_A;
        }
        if (Config.allowVanillaControls()) {
            if (keyCode == mc.field_71474_y.field_74370_x.func_151463_i()) {
                return mc.field_71474_y.field_74370_x;
            }
            if (keyCode == mc.field_71474_y.field_74366_z.func_151463_i()) {
                return mc.field_71474_y.field_74366_z;
            }
            if (keyCode == mc.field_71474_y.field_74368_y.func_151463_i()) {
                return mc.field_71474_y.field_74368_y;
            }
        }
        return null;
    }
}

