/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import dynamicswordskills.client.gui.AbstractGuiOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.SkillBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ComboOverlay
extends AbstractGuiOverlay {
    private Combo combo = null;
    private String label;
    private String comboSize;
    private String comboDamage;
    private int lastComboSize = 0;
    private long displayStartTime;
    private static final long DISPLAY_TIME = 5000L;

    public ComboOverlay(Minecraft mc) {
        super(mc);
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return Config.comboHudHAlign;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return Config.comboHudVAlign;
    }

    @Override
    public boolean allowMergeX(boolean rendered) {
        return false;
    }

    @Override
    public boolean shouldRender() {
        if (!Config.isComboHudEnabled) {
            return false;
        }
        ICombo iCombo = DSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).getComboSkill();
        if (iCombo != null && iCombo.getCombo() != null && this.combo != iCombo.getCombo()) {
            this.combo = iCombo.getCombo();
            this.lastComboSize = this.combo.getNumHits();
            this.displayStartTime = Minecraft.func_71386_F();
            if (this.combo.isFinished()) {
                iCombo.setCombo(null);
                PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)iCombo)));
            }
        }
        if (this.combo != null && this.combo.getNumHits() > 0) {
            if (this.lastComboSize != this.combo.getNumHits()) {
                this.lastComboSize = this.combo.getNumHits();
                this.displayStartTime = Minecraft.func_71386_F();
            }
            return Minecraft.func_71386_F() - this.displayStartTime < 5000L;
        }
        return false;
    }

    @Override
    protected void setup(ScaledResolution resolution) {
        int n = Math.min(this.combo.getDamageList().size(), Config.getHitsToDisplay());
        this.height = (n + 3) * this.mc.field_71466_p.field_78288_b;
        this.label = new TextComponentTranslation(this.combo.isFinished() ? "combo.finished" : "combo.combo", new Object[]{this.combo.getLabel()}).func_150260_c();
        this.comboSize = new TextComponentTranslation("combo.size", new Object[]{this.combo.getNumHits(), this.combo.getMaxNumHits()}).func_150260_c();
        this.comboDamage = new TextComponentTranslation("combo.damage", new Object[]{String.format("%.1f", Float.valueOf(this.combo.getDamage()))}).func_150260_c();
        this.width = Math.max(this.mc.field_71466_p.func_78256_a(this.label), this.mc.field_71466_p.func_78256_a(this.comboDamage));
        this.setPosX(resolution, this.getOffsetX(2) + Config.comboHudOffsetX);
        this.setPosY(resolution, this.getOffsetY(2) + Config.comboHudOffsetY);
    }

    @Override
    protected void render(ScaledResolution resolution) {
        int xPos = this.getLeft();
        int yPos = this.getTop();
        this.mc.field_71466_p.func_175065_a(this.label, (float)xPos, (float)yPos, this.combo.isFinished() ? 9699539 : 0xEEEE00, true);
        this.mc.field_71466_p.func_175065_a(this.comboSize, (float)(xPos + this.getOffset(this.comboSize)), (float)(yPos += this.mc.field_71466_p.field_78288_b), 0xFFFFFF, true);
        this.mc.field_71466_p.func_175065_a(this.comboDamage, (float)(xPos + this.getOffset(this.comboDamage)), (float)(yPos += this.mc.field_71466_p.field_78288_b), 0xFFFFFF, true);
        List<Float> damageList = this.combo.getDamageList();
        int n = Math.min(damageList.size(), Config.getHitsToDisplay());
        for (int i = 0; i < n; ++i) {
            String s = String.format("+%.1f", damageList.get(damageList.size() - i - 1));
            this.mc.field_71466_p.func_175065_a(s, (float)(xPos + this.getOffset(s)), (float)(yPos += this.mc.field_71466_p.field_78288_b), 0xFFFFFF, true);
        }
    }

    private int getOffset(String s) {
        switch (this.getHorizontalAlignment()) {
            case LEFT: {
                return 2;
            }
            case CENTER: {
                return this.getWidth() / 2 - this.mc.field_71466_p.func_78256_a(s) / 2;
            }
            case RIGHT: {
                return this.getWidth() - this.mc.field_71466_p.func_78256_a(s) - 2;
            }
        }
        return 0;
    }
}

