/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import dynamicswordskills.client.gui.AbstractGuiOverlay;
import dynamicswordskills.client.gui.IGuiOverlay;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.SkillActive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEndingBlowOverlay
extends AbstractGuiOverlay {
    private long displayStartTime;
    private static final long DISPLAY_TIME = 1000L;

    public GuiEndingBlowOverlay(Minecraft mc) {
        super(mc);
    }

    @Override
    public IGuiOverlay.HALIGN getHorizontalAlignment() {
        return Config.endingBlowHudHAlign;
    }

    @Override
    public IGuiOverlay.VALIGN getVerticalAlignment() {
        return Config.endingBlowHudVAlign;
    }

    @Override
    public boolean shouldRender() {
        if (!Config.isEndingBlowHudEnabled) {
            return false;
        }
        SkillActive skill = DSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).getActiveSkill(SkillActive.endingBlow);
        if (skill == null) {
            this.displayStartTime = 0L;
        } else if (skill.canUse((EntityPlayer)this.mc.field_71439_g)) {
            this.displayStartTime = Minecraft.func_71386_F();
        } else if (((EndingBlow)skill).getLastActivationTime() < this.displayStartTime) {
            this.displayStartTime = 0L;
        }
        return Minecraft.func_71386_F() - this.displayStartTime < 1000L;
    }

    @Override
    protected void setup(ScaledResolution resolution) {
        this.height = this.mc.field_71466_p.field_78288_b;
        this.width = this.mc.field_71466_p.func_78256_a(new TextComponentTranslation("combo.ending", new Object[0]).func_150260_c());
        this.setPosX(resolution, Config.endingBlowHudOffsetX);
        this.setPosY(resolution, Config.endingBlowHudOffsetY);
    }

    @Override
    protected void render(ScaledResolution resolution) {
        this.mc.field_71466_p.func_175065_a(new TextComponentTranslation("combo.ending", new Object[0]).func_150260_c(), (float)this.x, (float)this.y, 0xFF0000, true);
    }
}

