/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.command;

import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandGrantSkill
extends CommandBase {
    public static final ICommand INSTANCE = new CommandGrantSkill();

    public String func_71517_b() {
        return "grantskill";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender player) {
        return "commands.grantskill.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP commandSender = CommandBase.func_71521_c((ICommandSender)sender);
        EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)player);
        if (args.length == 2 && "all".equals(args[1])) {
            boolean flag = true;
            for (SkillBase skill : SkillBase.getSkills()) {
                if (!Config.isSkillEnabled(skill.getId()) || skills.grantSkill(skill.getId(), skill.getMaxLevel())) continue;
                flag = false;
            }
            if (flag) {
                PlayerUtils.sendTranslatedChat((EntityPlayer)player, "commands.grantskill.notify.all", new Object[0]);
                if (commandSender == player) return;
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.success.all", player.func_145748_c_());
                return;
            } else {
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.success.partial", player.func_145748_c_());
            }
            return;
        } else {
            byte oldLevel;
            if (args.length != 3) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            SkillBase skill = SkillBase.getSkillByName(args[1]);
            if (skill == null) {
                throw new CommandException("commands.skill.generic.unknown", new Object[]{args[1]});
            }
            int level = CommandBase.func_175764_a((String)args[2], (int)1, (int)10);
            if (level <= (oldLevel = skills.getTrueSkillLevel(skill))) throw new CommandException("commands.grantskill.failure.low", new Object[]{player.func_145748_c_(), new TextComponentTranslation(skill.getTranslationString(), new Object[0]), (int)oldLevel});
            if (!Config.isSkillEnabled(skill.getId())) {
                throw new CommandException("commands.grantskill.failure.disabled", new Object[]{new TextComponentTranslation(skill.getTranslationString(), new Object[0])});
            }
            if (!skills.grantSkill(skill.getId(), (byte)level)) throw new CommandException("commands.grantskill.failure.player", new Object[]{player.func_145748_c_(), new TextComponentTranslation(skill.getTranslationString(), new Object[0])});
            PlayerUtils.sendTranslatedChat((EntityPlayer)player, "commands.grantskill.notify.one", new TextComponentTranslation(skill.getTranslationString(), new Object[0]), skills.getTrueSkillLevel(skill));
            if (commandSender == player) return;
            PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.success.one", player.func_145748_c_(), new TextComponentTranslation(skill.getTranslationString(), new Object[0]), skills.getTrueSkillLevel(skill));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        switch (args.length) {
            case 1: {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            case 2: {
                return CommandBase.func_71530_a((String[])args, (String[])SkillBase.getSkillNames());
            }
        }
        return null;
    }
}

