/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EntityLeapingBlow
extends EntityThrowable {
    private List<Integer> affectedEntities = new ArrayList<Integer>();
    private float damage = 2.0f;
    private int lifespan = 12;
    private int level = 0;
    private static final float BASE_SIZE = 1.0f;
    private static final float HEIGHT = 0.5f;

    public EntityLeapingBlow(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70181_x = 0.0;
    }

    public EntityLeapingBlow(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70163_u = thrower.field_70163_u + 0.2;
        this.field_70181_x = 0.0;
    }

    public EntityLeapingBlow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70181_x = 0.0;
    }

    public void func_184538_a(Entity thrower, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float inaccuracy) {
        super.func_184538_a(thrower, rotationPitch, rotationYaw, pitchOffset, velocity, inaccuracy);
        this.field_70181_x = 0.0;
    }

    public EntityLeapingBlow setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntityLeapingBlow setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    private double getRangeSquared() {
        return (3.0 + (double)this.level) * (3.0 + (double)this.level);
    }

    private int getPotionDuration() {
        return 50 + this.level * 10;
    }

    private AxisAlignedBB getAoE() {
        return this.func_174813_aQ().func_72321_a((double)(0.25f * (float)this.level), 0.0, (double)(0.25f * (float)this.level));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_174854_a || this.field_70173_aa > this.lifespan) {
            this.func_70106_y();
        }
        if (!this.func_130014_f_().field_72995_K) {
            List targets = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.getAoE());
            for (EntityLivingBase target : targets) {
                double d0;
                if (this.affectedEntities.contains(target.func_145782_y()) || target == this.func_85052_h() || TargetUtils.isTargetInFrontOf((Entity)this, (Entity)target, 30.0f)) continue;
                this.affectedEntities.add(target.func_145782_y());
                float d = this.damage;
                if (this.func_85052_h() != null && (double)(d = (float)((double)d * ((d0 = 1.0 - this.func_85052_h().func_70068_e((Entity)target) / this.getRangeSquared()) > 1.0 ? 1.0 : d0))) < 0.5) {
                    return;
                }
                if (!target.func_70097_a(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.func_85052_h()), d)) continue;
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.getPotionDuration()));
            }
        } else {
            int[] nArray;
            EnumParticleTypes particle;
            double vX = this.field_70179_y;
            double vZ = this.field_70159_w;
            AxisAlignedBB bb = this.func_174813_aQ();
            int i = MathHelper.func_76128_c((double)(this.field_70165_t + (bb.field_72336_d - bb.field_72340_a) / 2.0));
            int j = MathHelper.func_76128_c((double)this.field_70163_u) - 1;
            int k = MathHelper.func_76128_c((double)(this.field_70161_v + (bb.field_72334_f - bb.field_72339_c) / 2.0));
            IBlockState state = this.func_130014_f_().func_180495_p(new BlockPos(i, j, k));
            EnumParticleTypes enumParticleTypes = particle = state.func_185901_i() == EnumBlockRenderType.INVISIBLE ? EnumParticleTypes.CRIT : EnumParticleTypes.BLOCK_CRACK;
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = Block.func_176210_f((IBlockState)state);
            }
            int[] stateId = nArray;
            for (int n = 0; n < 4; ++n) {
                this.func_130014_f_().func_175688_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, vX + this.field_70146_Z.nextGaussian(), 0.01, vZ + this.field_70146_Z.nextGaussian(), stateId);
                this.func_130014_f_().func_175688_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, -vX + this.field_70146_Z.nextGaussian(), 0.01, -vZ + this.field_70146_Z.nextGaussian(), stateId);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.func_130014_f_().field_72995_K) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                Entity entity = result.field_72308_g;
                if (entity instanceof EntityLivingBase && !this.affectedEntities.contains(entity.func_145782_y()) && entity != this.func_85052_h()) {
                    this.affectedEntities.add(entity.func_145782_y());
                    if (entity.func_70097_a(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.func_85052_h()), this.damage)) {
                        PlayerUtils.playSoundAtEntity(this.func_130014_f_(), entity, ModSounds.HURT_FLESH, SoundCategory.PLAYERS, 0.4f, 0.5f);
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
                    }
                }
            } else if (this.func_130014_f_().func_180495_p(result.func_178782_a()).func_185904_a().func_76230_c()) {
                this.func_70106_y();
            }
        }
    }

    public float getVelocity() {
        return 0.5f;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("level", this.level);
        compound.func_74768_a("lifespan", this.lifespan);
        compound.func_74783_a("affectedEntities", ArrayUtils.toPrimitive((Integer[])this.affectedEntities.toArray(new Integer[this.affectedEntities.size()])));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("damage");
        this.level = compound.func_74762_e("level");
        this.lifespan = compound.func_74762_e("lifespan");
        int[] entities = compound.func_74759_k("affectedEntities");
        for (int i = 0; i < entities.length; ++i) {
            this.affectedEntities.add(entities[i]);
        }
    }
}

