/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.SwordBeam;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySwordBeam
extends EntityThrowable {
    private float damage = 4.0f;
    private int level = 1;
    private int lifespan = 12;

    public EntitySwordBeam(World world) {
        super(world);
    }

    public EntitySwordBeam(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntitySwordBeam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70088_a() {
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntitySwordBeam setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntitySwordBeam setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public float getVelocity() {
        return 1.0f + (float)this.level * 0.15f;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_174854_a || this.field_70173_aa > this.lifespan) {
            this.func_70106_y();
        }
        for (int i = 0; i < 2; ++i) {
            EnumParticleTypes particle = i % 2 == 1 ? EnumParticleTypes.CRIT_MAGIC : EnumParticleTypes.CRIT;
            this.func_130014_f_().func_175688_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w + this.field_70146_Z.nextGaussian(), 0.01, this.field_70179_y + this.field_70146_Z.nextGaussian(), new int[0]);
            this.func_130014_f_().func_175688_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.field_70159_w + this.field_70146_Z.nextGaussian(), 0.01, -this.field_70179_y + this.field_70146_Z.nextGaussian(), new int[0]);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.func_130014_f_().field_72995_K) {
            SwordBeam skill;
            EntityPlayer player = this.func_85052_h() instanceof EntityPlayer ? (EntityPlayer)this.func_85052_h() : null;
            SwordBeam swordBeam = skill = player != null ? (SwordBeam)DSSPlayerInfo.get(player).getPlayerSkill(SkillBase.swordBeam) : null;
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (result.field_72308_g == player) {
                    return;
                }
                if (player != null) {
                    if (skill != null) {
                        skill.onImpact(player, false);
                    }
                    if (result.field_72308_g.func_70097_a(DamageUtils.causeIndirectComboDamage((Entity)this, (Entity)player).func_76349_b(), this.damage)) {
                        PlayerUtils.playSoundAtEntity(this.func_130014_f_(), result.field_72308_g, ModSounds.HURT_FLESH, SoundCategory.PLAYERS, 0.4f, 0.5f);
                    }
                    this.damage *= 0.8f;
                }
                if (this.level < SkillBase.swordBeam.getMaxLevel()) {
                    this.func_70106_y();
                }
            } else if (this.func_130014_f_().func_180495_p(result.func_178782_a()).func_185904_a().func_76230_c()) {
                if (player != null && skill != null) {
                    skill.onImpact(player, true);
                }
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("level", this.level);
        compound.func_74768_a("lifespan", this.lifespan);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("damage");
        this.level = compound.func_74762_e("level");
        this.lifespan = compound.func_74762_e("lifespan");
    }
}

