/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import dynamicswordskills.capability.SimpleCapabilityProvider;
import dynamicswordskills.entity.DSSPlayerInfo;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public interface IPlayerInfo {
    public DSSPlayerInfo get();

    public static class CapabilityPlayerInfo {
        @CapabilityInject(value=IPlayerInfo.class)
        public static final Capability<IPlayerInfo> PLAYER_INFO = null;
        public static final ResourceLocation ID = new ResourceLocation("dynamicswordskills", "PlayerInfo");

        @Nullable
        public static IPlayerInfo getMaxHealth(EntityLivingBase entity) {
            return (IPlayerInfo)entity.getCapability(PLAYER_INFO, null);
        }

        public static ICapabilityProvider createProvider(IPlayerInfo info) {
            return new SimpleCapabilityProvider<IPlayerInfo>(PLAYER_INFO, null, info);
        }

        public static void register() {
            CapabilityManager.INSTANCE.register(IPlayerInfo.class, (Capability.IStorage)new Capability.IStorage<IPlayerInfo>(){

                public NBTBase writeNBT(Capability<IPlayerInfo> capability, IPlayerInfo instance, EnumFacing side) {
                    return instance.get().writeNBT(new NBTTagCompound());
                }

                public void readNBT(Capability<IPlayerInfo> capability, IPlayerInfo instance, EnumFacing side, NBTBase nbt) {
                    instance.get().readNBT((NBTTagCompound)nbt);
                }
            }, (Callable)new Callable<IPlayerInfo>(){

                @Override
                public IPlayerInfo call() throws Exception {
                    return new PlayerInfo(null);
                }
            });
            MinecraftForge.EVENT_BUS.register((Object)new CapabilityPlayerInfo());
        }

        @SubscribeEvent
        public void attach(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                PlayerInfo info = new PlayerInfo(new DSSPlayerInfo((EntityPlayer)event.getObject()));
                event.addCapability(ID, CapabilityPlayerInfo.createProvider(info));
            }
        }
    }

    public static class PlayerInfo
    implements IPlayerInfo {
        private final DSSPlayerInfo info;

        public PlayerInfo(DSSPlayerInfo info) {
            this.info = info;
        }

        @Override
        public DSSPlayerInfo get() {
            return this.info;
        }
    }
}

