/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.item;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.item.IModItem;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkillOrb
extends Item
implements IModItem {
    public ItemSkillOrb() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(DynamicSwordSkills.tabSkills);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SkillBase skill;
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_130014_f_().field_72995_K && (skill = SkillBase.getSkill(stack.func_77952_i())) != null) {
            if (!Config.isSkillEnabled(skill.getId())) {
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.use.disabled", new TextComponentTranslation(skill.getTranslationString(), new Object[0]));
            } else if (DSSPlayerInfo.get(player).grantSkill(skill)) {
                PlayerUtils.playSound(player, ModSounds.LEVEL_UP, SoundCategory.PLAYERS, 1.0f, 1.0f);
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.levelup", new TextComponentTranslation(skill.getTranslationString(), new Object[0]), DSSPlayerInfo.get(player).getTrueSkillLevel(skill));
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.dss.skill.maxlevel", new TextComponentTranslation(skill.getTranslationString(), new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = SkillBase.getSkill(stack.func_77952_i());
        return new TextComponentTranslation(super.func_77658_a() + ".name", new Object[]{skill == null ? "" : skill.getDisplayName()}).func_150260_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (SkillBase skill : SkillBase.getSkills()) {
            list.add((Object)new ItemStack((Item)this, 1, (int)skill.getId()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        SkillBase skill;
        if (world != null && SkillBase.doesSkillExist(stack.func_77952_i()) && (skill = DSSPlayerInfo.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getPlayerSkill(SkillBase.getSkill(stack.func_77952_i()))) != null) {
            if (!Config.isSkillEnabled(skill.getId())) {
                list.add(TextFormatting.DARK_RED + new TextComponentTranslation("skill.dss.disabled", new Object[0]).func_150260_c());
            } else if (skill.getLevel() > 0) {
                list.add(TextFormatting.GOLD + skill.getLevelDisplay(true));
                list.addAll(skill.getTranslatedTooltip((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            } else {
                list.add(TextFormatting.ITALIC + new TextComponentTranslation("tooltip.dss.skillorb.desc.0", new Object[0]).func_150260_c());
            }
        }
    }

    @Override
    public String[] getVariants() {
        String[] variants = new String[SkillBase.getNumSkills()];
        for (SkillBase skill : SkillBase.getSkills()) {
            variants[skill.getId()] = skill.getIconTexture();
        }
        return variants;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerResources() {
        String[] variants = this.getVariants();
        for (int i = 0; i < variants.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(variants[i], "inventory"));
        }
    }
}

